/****************************************************************
 *  win_cpu.h
 *			Window handling for CPU messages
 *
 *  2000-04-28  Bodo Wenzel  Creation
 *  2001-02-07  Bodo Wenzel  Debug enhancements
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

#ifndef WIN_CPU_H
#define WIN_CPU_H

#include "emulate.h"
#include "emu_wrap.h"

/* === Functions ==============================================	*/

int cpu_open(void);
void cpu_close(int handle);

void cpu_redraw(int handle,int rx,int ry,int rw,int rh);
void cpu_sized(int handle,int x,int y,int w,int h);
void cpu_fulled(int handle);
void cpu_moved(int handle,int x,int y,int w,int h);
void cpu_vslided(int handle,int pos);
void cpu_hslided(int handle,int pos);
void cpu_arrowed(int handle,int arrow);

int cpu_add_line(int handle,EMU_COMBO *emulation,
                 EMU_STATE *state,CPU_REGS *regs);
void cpu_free_lines(int handle);

/* === End ====================================================	*/

#endif
