/****************************************************************
 *  palm.c
 *			Functions for Palm binary export
 *
 *  2000-03-07  Bodo Wenzel  Creation in test
 *  2000-05-04  Bodo Wenzel  Copied to full version
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

/* === Includes ===============================================	*/

#include <stdio.h>
#include <string.h>
#include <ext.h>
#include <aes.h>

#include "palm.h"
#include "stemboy.h"
#include "emu_wrap.h"

/* === Constants ==============================================	*/

#define  FALSE  (0)
#define  TRUE   (!FALSE)

/* === Functions ==============================================	*/

void palm_export(void) {
  /*------------------*/
  static char    fp[PATH_MAX+10]="";
  static char    fn[20]="";
         char    n[PATH_MAX+30];
         char    *p;
         int     b;
         FILE    *f;
         OBSPEC  *alert;
         size_t  l;

  if (fp[0]=='\0') {
    if (getcwd(fp,PATH_MAX)==NULL)
      fp[0]='\0';
    b=(int)(strlen(fp)-1);
    if (fp[b]=='\\')
      fp[b]='\0';
    strcat(fp,"\\*.BIN");
  }

  if (!fsel_input(fp,fn,&b))
    b=0;
  if (b==0 || fn[0]=='\0')
    return;

  strcpy(n,fp);
  if ((p=strrchr(n,'\\'))==NULL)
    p=n;
  else
    p++;
  strcpy(p,fn);

  f=fopen(n,"wb");
  if (f==NULL) {
    rsrc_gaddr(R_FRSTR,AFWRERR,&alert);
    form_alert(1,alert->free_string);
    return;
  }

  l=palm_end-palm_begin;
  if (fwrite(palm_begin,sizeof(unsigned char),l,f)!=l) {
    fclose(f);
    remove(n);
    rsrc_gaddr(R_FRSTR,AFWRERR,&alert);
    form_alert(1,alert->free_string);
    return;
  }

  fclose(f);
}

/* === End ====================================================	*/
