/****************************************************************
 *  gem_add.c
 *			Additional GEM functions
 *
 *  2000-03-07  Bodo Wenzel  Creation in test
 *  2000-04-24  Bodo Wenzel  Copied to full version
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

/* === Includes ===============================================	*/

#include <aes.h>

#include "gem_add.h"

/* === Variables ==============================================	*/

int     ap_id;
int     vdi_handle;
int     wchr,hchr;
OBJECT  *menu;

/* === Functions ==============================================	*/

int rc_intersect(int cx,int cy,int cw,int ch,
                 int *rx,int *ry,int *rw,int *rh) {
  /*---------------------------------------------*/
  int  ix0,iy0,ix1,iy1;

  ix0=(*rx>cx) ? *rx : cx;
  ix1=((*rx+*rw)<(cx+cw)) ? *rx+*rw : cx+cw;
  iy0=(*ry>cy) ? *ry : cy;
  iy1=((*ry+*rh)<(cy+ch)) ? *ry+*rh : cy+ch;

  if (ix1<=ix0 || iy1<=iy0)
    return(0);

  *rx=ix0;
  *ry=iy0;
  *rw=ix1-ix0;
  *rh=iy1-iy0;
  return(1);
}

/* === End ====================================================	*/
