;****************************************************************
;*  gbemu_cb.s
;*			Emulation of the Gameboy CPU
;*			(Opcodes after prefix byte $cb)
;*
;*  2000-02-23  Bodo Wenzel  Creation
;*  2000-09-29  Bodo Wenzel  Some improvements
;****************************************************************
;
;  (c)2000 Bodo Wenzel
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
;****************************************************************

macro	cb$0			;rlc b
	swap	d6
	swap	d5
	move.b	d5,d0
	roxl.b	#1,d0
	rol.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$1			;rlc c
	swap	d6
	move.b	d5,d0
	roxl.b	#1,d0
	rol.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$2			;rlc d
	swap	d6
	swap	d4
	move.b	d4,d0
	roxl.b	#1,d0
	rol.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$3			;rlc e
	swap	d6
	move.b	d4,d0
	roxl.b	#1,d0
	rol.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$4			;rlc h
	swap	d6
	swap	d3
	move.b	d3,d0
	roxl.b	#1,d0
	rol.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$5			;rlc l
	swap	d6
	move.b	d3,d0
	roxl.b	#1,d0
	rol.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$6			;rlc (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	roxl.b	#1,d0
	move.b	(a3),d0
	rol.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$7			;rlc a
	swap	d6
	move.b	d7,d0
	roxl.b	#1,d0
	rol.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$8			;rrc b
	swap	d6
	swap	d5
	move.b	d5,d0
	roxr.b	#1,d0
	ror.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$9			;rrc c
	swap	d6
	move.b	d5,d0
	roxr.b	#1,d0
	ror.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$a			;rrc d
	swap	d6
	swap	d4
	move.b	d4,d0
	roxr.b	#1,d0
	ror.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$b			;rrc e
	swap	d6
	move.b	d4,d0
	roxr.b	#1,d0
	ror.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$c			;rrc h
	swap	d6
	swap	d3
	move.b	d3,d0
	roxr.b	#1,d0
	ror.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$d			;rrc l
	swap	d6
	move.b	d3,d0
	roxr.b	#1,d0
	ror.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$e			;rrc (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	roxr.b	#1,d0
	move.b	(a3),d0
	ror.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$f			;rrc a
	swap	d6
	move.b	d7,d0
	roxr.b	#1,d0
	ror.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$10			;rl b
	swap	d6
	swap	d5
	move	d6,ccr
	roxl.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$11			;rl c
	swap	d6
	move	d6,ccr
	roxl.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$12			;rl d
	swap	d6
	swap	d4
	move	d6,ccr
	roxl.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$13			;rl e
	swap	d6
	move	d6,ccr
	roxl.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$14			;rl h
	swap	d6
	swap	d3
	move	d6,ccr
	roxl.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$15			;rl l
	swap	d6
	move	d6,ccr
	roxl.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$16			;rl (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	move	d6,ccr
	roxl.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$17			;rl a
	swap	d6
	move	d6,ccr
	roxl.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$18			;rr b
	swap	d6
	swap	d5
	move	d6,ccr
	roxr.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$19			;rr c
	swap	d6
	move	d6,ccr
	roxr.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$1a			;rr d
	swap	d6
	swap	d4
	move	d6,ccr
	roxr.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$1b			;rr e
	swap	d6
	move	d6,ccr
	roxr.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$1c			;rr h
	swap	d6
	swap	d3
	move	d6,ccr
	roxr.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$1d			;rr l
	swap	d6
	move	d6,ccr
	roxr.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$1e			;rr (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	move	d6,ccr
	roxr.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$1f			;rr a
	swap	d6
	move	d6,ccr
	roxr.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$20			;sla b
	swap	d6
	swap	d5
	asl.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$21			;sla c
	swap	d6
	asl.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$22			;sla d
	swap	d6
	swap	d4
	asl.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$23			;sla e
	swap	d6
	asl.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$24			;sla h
	swap	d6
	swap	d3
	asl.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$25			;sla l
	swap	d6
	asl.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$26			;sla (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	asl.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$27			;sla a
	swap	d6
	asl.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$28			;sra b
	swap	d6
	swap	d5
	asr.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$29			;sra c
	swap	d6
	asr.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$2a			;sra d
	swap	d6
	swap	d4
	asr.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$2b			;sra e
	swap	d6
	asr.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$2c			;sra h
	swap	d6
	swap	d3
	asr.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$2d			;sra l
	swap	d6
	asr.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$2e			;sra (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	asr.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$2f			;sra a
	swap	d6
	asr.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$30			;swap b
	swap	d6
	swap	d5
	move	#MASK_NC,ccr
	rol.b	#4,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$31			;swap c
	swap	d6
	move	#MASK_NC,ccr
	rol.b	#4,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$32			;swap d
	swap	d6
	swap	d4
	move	#MASK_NC,ccr
	rol.b	#4,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$33			;swap e
	swap	d6
	move	#MASK_NC,ccr
	rol.b	#4,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$34			;swap h
	swap	d6
	swap	d3
	move	#MASK_NC,ccr
	rol.b	#4,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$35			;swap l
	swap	d6
	move	#MASK_NC,ccr
	rol.b	#4,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$36			;swap (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	move	#MASK_NC,ccr
	rol.b	#4,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$37			;swap a
	swap	d6
	move	#MASK_NC,ccr
	rol.b	#4,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$38			;srl b
	swap	d6
	swap	d5
	lsr.b	#1,d5
	move	sr,d6
	swap	d5
	swap	d6
	next_pc
	endm

macro	cb$39			;srl c
	swap	d6
	lsr.b	#1,d5
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$3a			;srl d
	swap	d6
	swap	d4
	lsr.b	#1,d4
	move	sr,d6
	swap	d4
	swap	d6
	next_pc
	endm

macro	cb$3b			;srl e
	swap	d6
	lsr.b	#1,d4
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$3c			;srl h
	swap	d6
	swap	d3
	lsr.b	#1,d3
	move	sr,d6
	swap	d3
	swap	d6
	next_pc
	endm

macro	cb$3d			;srl l
	swap	d6
	lsr.b	#1,d3
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$3e			;srl (hl)
	swap	d6
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	move.b	(a3),d0
	lsr.b	#1,d0
	move	sr,d6
	mem_wr	d2
	swap	d6
	next_pc
	endm

macro	cb$3f			;srl a
	swap	d6
	lsr.b	#1,d7
	move	sr,d6
	swap	d6
	next_pc
	endm

macro	cb$40			;bit 0,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#16,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$41			;bit 0,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#0,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$42			;bit 0,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#16,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$43			;bit 0,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#0,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$44			;bit 0,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#16,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$45			;bit 0,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#0,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$46			;bit 0,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#0,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$47			;bit 0,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#0,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$48			;bit 1,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#17,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$49			;bit 1,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#1,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$4a			;bit 1,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#17,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$4b			;bit 1,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#1,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$4c			;bit 1,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#17,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$4d			;bit 1,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#1,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$4e			;bit 1,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#1,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$4f			;bit 1,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#1,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$50			;bit 2,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#18,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$51			;bit 2,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#2,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$52			;bit 2,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#18,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$53			;bit 2,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#2,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$54			;bit 2,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#18,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$55			;bit 2,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#2,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$56			;bit 2,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#2,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$57			;bit 2,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#2,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$58			;bit 1,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#19,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$59			;bit 3,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#3,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$5a			;bit 3,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#19,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$5b			;bit 3,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#3,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$5c			;bit 3,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#19,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$5d			;bit 3,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#3,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$5e			;bit 3,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#3,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$5f			;bit 3,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#3,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$60			;bit 4,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#20,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$61			;bit 4,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#4,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$62			;bit 4,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#20,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$63			;bit 4,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#4,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$64			;bit 4,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#20,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$65			;bit 4,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#4,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$66			;bit 4,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#4,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$67			;bit 4,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#4,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$68			;bit 5,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#21,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$69			;bit 5,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#5,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$6a			;bit 5,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#21,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$6b			;bit 5,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#5,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$6c			;bit 5,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#21,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$6d			;bit 5,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#5,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$6e			;bit 5,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#5,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$6f			;bit 5,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#5,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$70			;bit 6,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#22,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$71			;bit 6,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#6,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$72			;bit 6,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#22,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$73			;bit 6,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#6,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$74			;bit 6,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#22,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$75			;bit 6,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#6,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$76			;bit 6,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#6,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$77			;bit 6,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#6,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$78			;bit 7,b
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#23,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$79			;bit 7,c
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#7,d5
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$7a			;bit 7,d
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#23,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$7b			;bit 7,e
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#7,d4
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$7c			;bit 7,h
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#23,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$7d			;bit 7,l
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#7,d3
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$7e			;bit 7,(hl)
	local	z
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#7,(a3)
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$7f			;bit 7,a
	local	z
	moveq	#FLAG_Z,d0
	bset	d0,d6
	btst	#7,d7
	beq.s	z
	bchg	d0,d6
z:	next_pc
	endm

macro	cb$80			;res 0,b
	moveq	#16,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$81			;res 0,c
	and.b	#!$01,d5
	next_pc
	endm

macro	cb$82			;res 0,d
	moveq	#16,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$83			;res 0,e
	and.b	#!$01,d4
	next_pc
	endm

macro	cb$84			;res 0,h
	moveq	#16,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$85			;res 0,l
	and.b	#!$01,d3
	next_pc
	endm

macro	cb$86			;res 0,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$01,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$87			;res 0,a
	and.b	#!$01,d7
	next_pc
	endm

macro	cb$88			;res 1,b
	moveq	#17,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$89			;res 1,c
	and.b	#!$02,d5
	next_pc
	endm

macro	cb$8a			;res 1,d
	moveq	#17,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$8b			;res 1,e
	and.b	#!$02,d4
	next_pc
	endm

macro	cb$8c			;res 1,h
	moveq	#17,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$8d			;res 1,l
	and.b	#!$02,d3
	next_pc
	endm

macro	cb$8e			;res 1,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$02,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$8f			;res 1,a
	and.b	#!$02,d7
	next_pc
	endm

macro	cb$90			;res 2,b
	moveq	#18,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$91			;res 2,c
	and.b	#!$04,d5
	next_pc
	endm

macro	cb$92			;res 2,d
	moveq	#18,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$93			;res 2,e
	and.b	#!$04,d4
	next_pc
	endm

macro	cb$94			;res 2,h
	moveq	#18,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$95			;res 2,l
	and.b	#!$04,d3
	next_pc
	endm

macro	cb$96			;res 2,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$04,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$97			;res 2,a
	and.b	#!$04,d7
	next_pc
	endm

macro	cb$98			;res 3,b
	moveq	#19,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$99			;res 3,c
	and.b	#!$08,d5
	next_pc
	endm

macro	cb$9a			;res 3,d
	moveq	#19,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$9b			;res 3,e
	and.b	#!$08,d4
	next_pc
	endm

macro	cb$9c			;res 3,h
	moveq	#19,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$9d			;res 3,l
	and.b	#!$08,d3
	next_pc
	endm

macro	cb$9e			;res 3,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$08,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$9f			;res 3,a
	and.b	#!$08,d7
	next_pc
	endm

macro	cb$a0			;res 4,b
	moveq	#20,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$a1			;res 4,c
	and.b	#!$10,d5
	next_pc
	endm

macro	cb$a2			;res 4,d
	moveq	#20,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$a3			;res 4,e
	and.b	#!$10,d4
	next_pc
	endm

macro	cb$a4			;res 4,h
	moveq	#20,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$a5			;res 4,l
	and.b	#!$10,d3
	next_pc
	endm

macro	cb$a6			;res 4,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$10,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$a7			;res 4,a
	and.b	#!$10,d7
	next_pc
	endm

macro	cb$a8			;res 5,b
	moveq	#21,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$a9			;res 5,c
	and.b	#!$20,d5
	next_pc
	endm

macro	cb$aa			;res 5,d
	moveq	#21,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$ab			;res 5,e
	and.b	#!$20,d4
	next_pc
	endm

macro	cb$ac			;res 5,h
	moveq	#21,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$ad			;res 5,l
	and.b	#!$20,d3
	next_pc
	endm

macro	cb$ae			;res 5,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$20,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$af			;res 5,a
	and.b	#!$20,d7
	next_pc
	endm

macro	cb$b0			;res 6,b
	moveq	#22,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$b1			;res 6,c
	and.b	#!$40,d5
	next_pc
	endm

macro	cb$b2			;res 6,d
	moveq	#22,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$b3			;res 6,e
	and.b	#!$40,d4
	next_pc
	endm

macro	cb$b4			;res 6,h
	moveq	#22,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$b5			;res 6,l
	and.b	#!$40,d3
	next_pc
	endm

macro	cb$b6			;res 6,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#!$40,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$b7			;res 6,a
	and.b	#!$40,d7
	next_pc
	endm

macro	cb$b8			;res 7,b
	moveq	#23,d0
	bclr	d0,d5
	next_pc
	endm

macro	cb$b9			;res 7,c
	and.b	#$ff^$80,d5
	next_pc
	endm

macro	cb$ba			;res 7,d
	moveq	#23,d0
	bclr	d0,d4
	next_pc
	endm

macro	cb$bb			;res 7,e
	and.b	#$ff^$80,d4
	next_pc
	endm

macro	cb$bc			;res 7,h
	moveq	#23,d0
	bclr	d0,d3
	next_pc
	endm

macro	cb$bd			;res 7,l
	and.b	#$ff^$80,d3
	next_pc
	endm

macro	cb$be			;res 7,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$ff^$80,d0
	and.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$bf			;res 7,a
	and.b	#$ff^$80,d7
	next_pc
	endm

macro	cb$c0			;set 0,b
	moveq	#16,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$c1			;set 0,c
	or.b	#$01,d5
	next_pc
	endm

macro	cb$c2			;set 0,d
	moveq	#16,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$c3			;set 0,e
	or.b	#$01,d4
	next_pc
	endm

macro	cb$c4			;set 0,h
	moveq	#16,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$c5			;set 0,l
	or.b	#$01,d3
	next_pc
	endm

macro	cb$c6			;set 0,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$01,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$c7			;set 0,a
	or.b	#$01,d7
	next_pc
	endm

macro	cb$c8			;set 1,b
	moveq	#17,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$c9			;set 1,c
	or.b	#$02,d5
	next_pc
	endm

macro	cb$ca			;set 1,d
	moveq	#17,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$cb			;set 1,e
	or.b	#$02,d4
	next_pc
	endm

macro	cb$cc			;set 1,h
	moveq	#17,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$cd			;set 1,l
	or.b	#$02,d3
	next_pc
	endm

macro	cb$ce			;set 1,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$02,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$cf			;set 1,a
	or.b	#$02,d7
	next_pc
	endm

macro	cb$d0			;set 2,b
	moveq	#18,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$d1			;set 2,c
	or.b	#$04,d5
	next_pc
	endm

macro	cb$d2			;set 2,d
	moveq	#18,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$d3			;set 2,e
	or.b	#$04,d4
	next_pc
	endm

macro	cb$d4			;set 2,h
	moveq	#18,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$d5			;set 2,l
	or.b	#$04,d3
	next_pc
	endm

macro	cb$d6			;set 2,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$04,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$d7			;set 2,a
	or.b	#$04,d7
	next_pc
	endm

macro	cb$d8			;set 3,b
	moveq	#19,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$d9			;set 3,c
	or.b	#$08,d5
	next_pc
	endm

macro	cb$da			;set 3,d
	moveq	#19,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$db			;set 3,e
	or.b	#$08,d4
	next_pc
	endm

macro	cb$dc			;set 3,h
	moveq	#19,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$dd			;set 3,l
	or.b	#$08,d3
	next_pc
	endm

macro	cb$de			;set 3,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$08,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$df			;set 3,a
	or.b	#$08,d7
	next_pc
	endm

macro	cb$e0			;set 4,b
	moveq	#20,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$e1			;set 4,c
	or.b	#$10,d5
	next_pc
	endm

macro	cb$e2			;set 4,d
	moveq	#20,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$e3			;set 4,e
	or.b	#$10,d4
	next_pc
	endm

macro	cb$e4			;set 4,h
	moveq	#20,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$e5			;set 4,l
	or.b	#$10,d3
	next_pc
	endm

macro	cb$e6			;set 4,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$10,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$e7			;set 4,a
	or.b	#$10,d7
	next_pc
	endm

macro	cb$e8			;set 5,b
	moveq	#21,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$e9			;set 5,c
	or.b	#$20,d5
	next_pc
	endm

macro	cb$ea			;set 5,d
	moveq	#21,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$eb			;set 5,e
	or.b	#$20,d4
	next_pc
	endm

macro	cb$ec			;set 5,h
	moveq	#21,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$ed			;set 5,l
	or.b	#$20,d3
	next_pc
	endm

macro	cb$ee			;set 5,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$20,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$ef			;set 5,a
	or.b	#$20,d7
	next_pc
	endm

macro	cb$f0			;set 6,b
	moveq	#22,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$f1			;set 6,c
	or.b	#$40,d5
	next_pc
	endm

macro	cb$f2			;set 6,d
	moveq	#22,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$f3			;set 6,e
	or.b	#$40,d4
	next_pc
	endm

macro	cb$f4			;set 6,h
	moveq	#22,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$f5			;set 6,l
	or.b	#$40,d3
	next_pc
	endm

macro	cb$f6			;set 6,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#$40,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$f7			;set 6,a
	or.b	#$40,d7
	next_pc
	endm

macro	cb$f8			;set 7,b
	moveq	#23,d0
	bset	d0,d5
	next_pc
	endm

macro	cb$f9			;set 7,c
	or.b	#-$80,d5
	next_pc
	endm

macro	cb$fa			;set 7,d
	moveq	#23,d0
	bset	d0,d4
	next_pc
	endm

macro	cb$fb			;set 7,e
	or.b	#-$80,d4
	next_pc
	endm

macro	cb$fc			;set 7,h
	moveq	#23,d0
	bset	d0,d3
	next_pc
	endm

macro	cb$fd			;set 7,l
	or.b	#-$80,d3
	next_pc
	endm

macro	cb$fe			;set 7,(hl)
	move.b	d3,d1
	move.l	d3,d2
	swap	d2
	mem_rd	d2
	moveq	#-$80,d0
	or.b	(a3),d0
	mem_wr	d2
	next_pc
	endm

macro	cb$ff			;set 7,a
	or.b	#-$80,d7
	next_pc
	endm

;================================================================
;	end of include
