/****************************************************************
 *  emulate.h
 *			High level functions of emulation
 *
 *  2000-04-28  Bodo Wenzel  Creation
 *  2000-06-02  Bodo Wenzel  External RAM pageable
 *  2000-06-06  Bodo Wenzel  New memory management
 *  2000-08-08  Bodo Wenzel  Added timing
 *  2000-09-29  Bodo Wenzel  PalmBoy scroller as GB code
 *  2000-12-17  Bodo Wenzel  Support of more cartridges
 *  2001-01-21  Bodo Wenzel  Joystick emulation via keys
 *  2001-02-10  Bodo Wenzel  Debug enhancements
 ****************************************************************

  (c)2000 Bodo Wenzel

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ****************************************************************/

#ifndef EMULATE_H
#define EMULATE_H

#include <time.h>

#include "emu_wrap.h"

/* === Variables ==============================================	*/

typedef  struct {
  unsigned char   int_enabled;
  long            run_result;
}  EMU_STATE;

extern  EMU_STATE  emu_state;

extern  clock_t  emu_time;
extern  long     emu_frames;

extern  unsigned char  *emu_rom;
extern  unsigned char  *emu_rom_pages[];
extern  unsigned char  emu_ram_ext[];
extern  unsigned char  *emu_ram_pages[];
extern  void  (*emu_v_ram_enable)(void);
extern  void  (*emu_v_roml_select)(void);
extern  void  (*emu_v_romh_select)(void);
extern  void  (*emu_v_ram_select)(void);
extern  void  (*emu_v_mode_select)(void);

extern  unsigned char  emu_direction;
extern  unsigned char  emu_command;
extern  char           emu_quit;

/* === Functions ==============================================	*/

void emu_init(void);
void emu_exit(void);

void emu_mykbd(void);
void emu_oldkbd(void);

void emu_reset(EMU_COMBO *emulation);
void emu_run(EMU_COMBO *emulation);

void emu_try_scroller(EMU_COMBO *emulation);
void emu_try_code(EMU_COMBO *emulation,int kchar);
void emu_set_bp(void);

/* === End ====================================================	*/

#endif
