;****************************************************************
;*  constant.s
;*			Constants to be included
;*
;*  2000-04-28  Bodo Wenzel  Creation
;*  2000-05-04  Bodo Wenzel  Changes to meet Pila requirements
;*  2000-05-06  Bodo Wenzel  External RAM pageable
;*  2000-09-09  Bodo Wenzel  Now nearly full screen emulation
;*  2000-09-30  Bodo Wenzel  PalmBoy scroller as GB code
;*  2000-10-22  Bodo Wenzel  Interrupts and timer
;*  2000-11-16  Bodo Wenzel  New screen rendering and
;*                           better joypad emulation
;*  2001-01-31  Bodo Wenzel  Support of more cartridges
;*  2001-02-05  Bodo Wenzel  New stack management
;****************************************************************
;
;  (c)2000 Bodo Wenzel
;
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
;****************************************************************

;================================================================
;	Return codes (<0)

ERR_DEBUG	equ	-1	;debug check failed
SINGLE_STEP	equ	-2	;single stepped
USER_STOP	equ	-3	;user stopped emulation
OPCODE_STOP	equ	-11	;STOP (opcode $10)
OP_NOT_IMPL	equ	-21	;unimplemented opcode
UNKNOWN		equ	-22	;unknown opcode
NO_MEM		equ	-23	;no memory at this address
NO_INP		equ	-24	;no input port at this address
NO_OUT		equ	-25	;no output port at this address
FTR_NOT_IMPL	equ	-26	;unimplemented feature

;================================================================
;	Debugging masks

DEBUG_STEP	equ	$1	;single stepping
DEBUG_JP32K	equ	$2	;check jumps beyond $7fff
DEBUG_NO_RW	equ	$4	;check missing addresses
DEBUG_PROFILE	equ	$8	;count opcode usage

;================================================================
;	Screen constants

SCR_WIDTH	equ	20	;number of tiles hor. visible
SCR_HEIGHT	equ	18	;number of tiles ver. visible

MAP_WRAP	equ	32	;number of tiles hor./ver.

SCR_YMAX	equ	143	;last line index

;================================================================
;	Timing constants

;calculated as 456 clocks per line / 6 clocks average per opcode
OPS_PER_LINE	equ	76	;number of opcodes per screen
				;line, this determines greatly
				;the emulation speed!

DIV_PER_LINE	equ	456	;ratio = hor. freq. to DIV freq.

VSYNC_PER_SEC	equ	60	;frame rate

;================================================================
;	Offsets for extensions

OFFSET_XT	equ	$d0	;limit by PalmOS
OFFSET_PROF	equ	$fc

CODE_RESET	equ	$0000+OFFSET_XT
;reserved	equ	$0100+OFFSET_XT..$0500+OFFSET_XT
CODE_SCROLLER	equ	$0600+OFFSET_XT
;reserved	equ	$0700+OFFSET_XT..$0f00+OFFSET_XT

V_LCD_LINE	equ	$1000+OFFSET_XT
V_OPCODE_STOP	equ	$1100+OFFSET_XT
BP_RTS		equ	$1200+OFFSET_XT
CALL_INT	equ	$1800+OFFSET_XT
;reserved	equ	$1900+OFFSET_XT
IO_WR_IE	equ	$1a00+OFFSET_XT
INT_CHECK	equ	$1b00+OFFSET_XT

V_RAM_ENABLE	equ	$2000+OFFSET_XT
V_ROML_SELECT	equ	$2100+OFFSET_XT
V_ROMH_SELECT	equ	$2200+OFFSET_XT
V_RAM_SELECT	equ	$2300+OFFSET_XT
V_MODE_SELECT	equ	$2400+OFFSET_XT
V_RAM_RD_EXT	equ	$2500+OFFSET_XT
V_RAM_WR_EXT	equ	$2600+OFFSET_XT
V_RAM_WR8087	equ	$2800+OFFSET_XT
V_RAM_WR888F	equ	$2900+OFFSET_XT
V_RAM_WR9097	equ	$2a00+OFFSET_XT
V_RAM_WR989B	equ	$2b00+OFFSET_XT
V_RAM_WR9C9F	equ	$2c00+OFFSET_XT
V_RAM_WR_OAM	equ	$2d00+OFFSET_XT

BASE_ROM_0	equ	$3000+OFFSET_XT
BASE_ROM_1	equ	$3004+OFFSET_XT
BASE_RAM_VID	equ	$3100+OFFSET_XT
BASE_RAM_EXT	equ	$3104+OFFSET_XT
BASE_RAM_INT	equ	$3108+OFFSET_XT
BASE_RAM_OAM	equ	$310c+OFFSET_XT
BASE_RAM_CPU	equ	$3110+OFFSET_XT
RAM_RD_EXT_STD	equ	$3200+OFFSET_XT
RAM_WR_EXT_STD	equ	$3300+OFFSET_XT

SP_PUSH_CORRECT	equ	$3400+OFFSET_XT
SP_POP_CORRECT	equ	$3500+OFFSET_XT
SP_ROM_CORRECT	equ	$3600+OFFSET_XT
SP_RAM_CORRECT	equ	$3700+OFFSET_XT

CPU_STATE_PC_B	equ	$4000+OFFSET_XT
CPU_STATE_PC	equ	$4004+OFFSET_XT
CPU_STATE_SP_B	equ	$4006+OFFSET_XT
CPU_STATE_SP	equ	$400a+OFFSET_XT
CPU_STATE_A	equ	$400c+OFFSET_XT
CPU_STATE_F	equ	$400d+OFFSET_XT
CPU_STATE_B	equ	$400e+OFFSET_XT
CPU_STATE_C	equ	$400f+OFFSET_XT
CPU_STATE_D	equ	$4010+OFFSET_XT
CPU_STATE_E	equ	$4011+OFFSET_XT
CPU_STATE_H	equ	$4012+OFFSET_XT
CPU_STATE_L	equ	$4013+OFFSET_XT
CPU_STATE_A_OLD	equ	$4014+OFFSET_XT

CYCLES		equ	$4100+OFFSET_XT
T_DIV		equ	$4102+OFFSET_XT
T_TMA		equ	$4104+OFFSET_XT
T_TIMA		equ	$4106+OFFSET_XT
T_D_TIMA	equ	$4108+OFFSET_XT
IO_WR_TAC	equ	$410a+OFFSET_XT

INT_IME		equ	$4200+OFFSET_XT
INT_IE		equ	$4201+OFFSET_XT
INT_IF		equ	$4202+OFFSET_XT
INT_IM		equ	$4203+OFFSET_XT

JOYPAD_PTR	equ	$4300+OFFSET_XT
JOYPAD_BOTH	equ	$4304+OFFSET_XT
JOYPAD_CMD	equ	$4305+OFFSET_XT
JOYPAD_DIR	equ	$4306+OFFSET_XT
JOYPAD_NONE	equ	$4307+OFFSET_XT

LCD_LCDC	equ	$4400+OFFSET_XT
LCD_STAT	equ	$4401+OFFSET_XT
LCD_SCY		equ	$4402+OFFSET_XT
LCD_SCX		equ	$4403+OFFSET_XT
LCD_I_LY	equ	$4404+OFFSET_XT
LCD_LY		equ	$4406+OFFSET_XT
LCD_LYC		equ	$4407+OFFSET_XT
;LCD_DMA	equ	$4408+OFFSET_XT		;unused
LCD_BGP		equ	$4409+OFFSET_XT
LCD_OBP0	equ	$440a+OFFSET_XT
LCD_OBP1	equ	$440b+OFFSET_XT
LCD_I_WY	equ	$440c+OFFSET_XT
LCD_WY		equ	$440e+OFFSET_XT
LCD_WX		equ	$440f+OFFSET_XT

V_IO_WR_LCDC	equ	$5000+OFFSET_XT
V_IO_RD_STAT	equ	$5100+OFFSET_XT
V_IO_WR_STAT	equ	$5200+OFFSET_XT
V_IO_WR_SCY	equ	$5300+OFFSET_XT
V_IO_WR_SCX	equ	$5400+OFFSET_XT
V_IO_WR_LY	equ	$5500+OFFSET_XT
V_IO_WR_LYC	equ	$5600+OFFSET_XT
V_IO_WR_DMA	equ	$5700+OFFSET_XT
V_IO_WR_BGP	equ	$5800+OFFSET_XT
V_IO_WR_OBP0	equ	$5900+OFFSET_XT
V_IO_WR_OBP1	equ	$5a00+OFFSET_XT
V_IO_WR_WY	equ	$5b00+OFFSET_XT
V_IO_WR_WX	equ	$5c00+OFFSET_XT

;================================================================
;	end of include
