/*
 * spareCALC using the  CF-Lib
 */
#include <cflib.h>
#include <stdio.h>
#include <math.h>
#include "sparcalc.h"
#ifndef FALSE
#define FALSE	0
#define TRUE	1
#endif
#define EOS                '\0'  /* End of string                  */
#define TLEN	255
#define rsc_string(a) (char *) get_obspec(language, a)

#ifdef __MTAES__
#define wind_create_grect(a,b)	wind_create(a,b)
#define wind_calc_grect(a,b,c,d)	wind_calc(a,b,c,d)
#define wind_open_grect(a,b)		wind_open(a,b)
#define wind_set_str(a,b,c)		wind_set_string(a,b,c)
extern int rc_intersect(GRECT *r1, GRECT *r2);
#endif


/* --------------------------------------------------------------------------- */
OBJECT	*menu, *calcdial, *astrodial, *wicon, *popups, *about, *language, *sharew, *equa;
WDIALOG	*calc_wdial, *sharew_dial, *astro_wdial, *about_wdial, *equa_wdial;
int screen_colors;
int		quit;
int		msg[8], vdi_handle;
int		event, msx, msy, mbutton, kstate, mclick, kreturn, win_handle;
int		modal = FALSE;
long 	Accum = 0;
int 	FlagNewNum = FALSE;
int		selectedOp =0;
int 	PendingOp = CALCC;
long	calcwert;
struct {
	const char * zeichen;
} mathe[] = {
	{ "+"},
	{ "-"},
	{ "*"},
	{ "/"},
	{ "="}
};
static void handle_msg(int *msg);
void NumPressed (int Num);
void Operation (int Op);
void ClearEntry (void);
void ClearCalc (void);
void call_guide(WDIALOG *wd,int obj,char *seite);

/* --------------------------------------------------------------------------- */
/* 
 * Ein Dummy-Fenster, dass einfach nur da ist, damit man sieht, dass bei 
 * app-modalen Dialogen Redraw-, Move- und Size-Aktionen ausgewertet 
 * werden.
*/
void redraw_win(int handle, int xc, int yc, int wc, int hc)
{
	GRECT	t1,t2;
	int	temp[4];
	
	hide_mouse();
	wind_update(TRUE);
	t2.g_x = xc; t2.g_y = yc; t2.g_w = wc; t2.g_h = hc;
	wind_get_grect(handle, WF_FIRSTXYWH, &t1);
	vsf_color(vdi_handle, 0);

	wind_get(handle, WF_WORKXYWH, &temp[0], &temp[1], &temp[2], &temp[3]);
	temp[2] += temp[0] - 1;
	temp[3] += temp[1] - 1;

	while (t1.g_w && t1.g_h)
	{
		if (rc_intersect(&t2, &t1))
		{
			set_clipping(vdi_handle, t1.g_x, t1.g_y, t1.g_w, t1.g_h, TRUE);
			v_bar(vdi_handle, temp);
		}
		wind_get(handle, WF_NEXTXYWH, &t1.g_x, &t1.g_y, &t1.g_w, &t1.g_h);
	}
	wind_update(FALSE);
	show_mouse();
}

void win_msg(int *msg)
{
	if (msg[3] == win_handle)
	{
		switch (msg[0])
		{
			case WM_CLOSED :
				wind_close(win_handle);
				break;
			case WM_BOTTOMED:
				wind_set(win_handle, WF_BOTTOM, 0, 0, 0, 0);
				break;
			case WM_REDRAW:
				redraw_win(win_handle, msg[4], msg[5], msg[6], msg[7]);
				break;
			case WM_NEWTOP:
			case WM_TOPPED:
				wind_set(win_handle, WF_TOP, 0, 0, 0, 0);
				break;
			case WM_MOVED:
				wind_set(win_handle, WF_CURRXYWH, msg[4], msg[5], msg[6], msg[7]);
				break;
			case WM_SIZED:
				wind_set(win_handle, WF_CURRXYWH, msg[4], msg[5], msg[6], msg[7]);
				break;
		}
	}
}

/* --------------------------------------------------------------------------- */

void about_open_cb(WDIALOG *wd)
{
}
int about_exit_cb(WDIALOG *wd, int obj)
{
	int	close = FALSE;
	switch (obj)
	{
		case DIINFSHA:
			set_state(wd->tree, obj, SELECTED, FALSE);
			redraw_wdobj(wd, DIINFSHA);
			open_wdial(sharew_dial, -1, -1);
			break;
		case DICALCOK :
		case WD_CLOSER :
			close = TRUE;
			break;
	}
	if (obj!=WD_CLOSER)
	{
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
	return close;
}
/* --------------------------------------------------------------------------- */
int sharew_exit_cb(WDIALOG *wd, int obj)
{
	int	close = FALSE;
	
	switch (obj)
	{
		case DISHAHLP:
			call_guide(wd, obj, "sparesharew");
			break;
		case DISHAOK:
			close = TRUE;
			break;	
		case WD_CLOSER :
			close = TRUE;
			break;
		
	}
	return close;
}

/* Ende Sharewareinfo */

void call_guide(WDIALOG *wd,int obj,char *seite)
{
	char	hyp[80];
	int		id;
	strcpy(hyp, "*:\\spartime.hyp ");
	strcat(hyp, seite);
	id = appl_find("ST-GUIDE");
	if (id > 0)
		send_vastart(id, hyp);
	if (obj>0) {
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
}

/* --------------------------------------------------------------------------- */
void equa_open_cb(WDIALOG *wd)
{
	set_int(wd->tree,PFELD, 0);
	set_int(wd->tree,QFELD, 0);
}
int equa_exit_cb(WDIALOG *wd, int obj)
{
	/* h1 und h2 sind Hilfsvariablen */
	double a,s,p,q,x2,x1,ergebnis2, ergebnis,h1,h2;
	char ptext[4], qtext[4],test[2048];
    char x1text[10], x2text[10], calc1[30], calc2[30], probe[30];
	int	close = FALSE;
	switch (obj)
	{
		case EQUACLIP:
		case EQUAOK:
			get_string(wd->tree,PFELD, ptext);
			get_string(wd->tree,QFELD, qtext);
			p = atof(ptext);
			q = atof(qtext);
			a = (p/2);
            a = pow(a, 2);
            a = a - q;
            s = -(p/2);
			strcpy(test, "Gleichungsberechnung mit der p/2-Formel\n");
			strcat(test,"    Equation Calculation using the p/2 formula\n");
			strcat(test,"x^2 + p * x = ??\n");

            if (a<0) {
				set_string(wd->tree,CALCX1, "Es existiert keine Loesung.");
				set_string(wd->tree,CALCX2, "There is no solution.");
				set_string(wd->tree,PROBE, " ");
            } else {
            	x1 = s + sqrt (a);
            	x2 = s - sqrt (a);
                sprintf(x1text, "%5.02f", x1);
                sprintf(x2text, "%5.02f", x2);
				set_string(wd->tree,X2, x2text);
				set_string(wd->tree,X1, x1text);

				a = pow(x1, 2);
				ergebnis2=a+(p*x1)+q;
			  	sprintf(calc1,"%5.02f+%5.02f*%5.02f = %5.02f",x1,p,x1,ergebnis);
				set_string(wd->tree,CALCX1, calc1);
			    strcat(test,calc1);
			    strcat(test,"\n");

				a = pow(x2, 2);
				ergebnis2=a+(p*x2)+q;
			  	sprintf(calc2,"%5.02f+%5.02f*%5.02f = %5.02f",x2,p,x2,ergebnis2);
				set_string(wd->tree,CALCX2, calc2);
			    strcat(test,calc2);

				h1 = x1*x2;
				h2 = x1+x2;
			  	sprintf(probe,"x1*x2 = q&x1+x2=-p | x1*x2=%5.02f x1+x2=%5.02f",h1,h2);
				set_string(wd->tree,PROBE, probe);
            }
			redraw_wdobj(wd, X1);
			redraw_wdobj(wd, X2);
			redraw_wdobj(wd, CALCX1);
			redraw_wdobj(wd, CALCX2);
			redraw_wdobj(wd, PROBE);
			if (obj == EQUACLIP) {
				scrap_clear();
			    strcat(test,"\n      Probe:");
			    strcat(test,"x1*x2  =q  & x1+x2=-p\n");
			    strcat(test,probe);
				scrap_wtxt(test);
			}
			break;
		case EQUACANCEL:
		case WD_CLOSER :
			close = TRUE;
			break;
	}
	if (obj!=WD_CLOSER)
	{
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
	return close;
}

void astro_open_cb(WDIALOG *wd)
{
	set_int(wd->tree,ASTROYEAR, 1970);
	set_int(wd->tree,ASTROMONTH, 1);
	set_int(wd->tree,ASTRODAY, 12);
}
int astro_exit_cb(WDIALOG *wd, int obj)
{
	int	close = FALSE;
	int tag, jahr, monat, auswahl;
	int	x,y;
	int start = 1901;
	char stern[10];
/*	const char * china;*/

	switch (obj)
	{
		case ASTROOK:
			tag = get_int(wd->tree,ASTRODAY);
			monat = get_int(wd->tree,ASTROMONTH);
			jahr = get_int(wd->tree,ASTROYEAR);
			auswahl = 1;
			if ( (monat == 1 && tag >=20) || (monat == 2 && tag <=18) ) {auswahl = 1;}
			if ( (monat == 2 && tag >=19) || (monat == 3 && tag <=20) ) {auswahl = 2;}
			if ( (monat == 3 && tag >=21) || (monat == 4 && tag <=19) ) {auswahl = 3;}
			if ( (monat == 4 && tag >=20) || (monat == 5 && tag <=20) ) {auswahl = 4;}
			if ( (monat == 5 && tag >=21) || (monat == 6 && tag <=21) ) {auswahl = 5;}
			if ( (monat == 6 && tag >=22) || (monat == 7 && tag <=22) ) {auswahl = 6;}
			if ( (monat == 7 && tag >=23) || (monat == 8 && tag <=22) ) {auswahl = 7;}
			if ( (monat == 8 && tag >=23) || (monat == 9 && tag <=22) ) {auswahl = 8;}
			if ( (monat == 9 && tag >=23) || (monat == 10 && tag <=22) ) {auswahl = 9;}
			if ( (monat == 10 && tag >=23) || (monat == 11 && tag <=21) ) {auswahl = 10;}
			if ( (monat == 11 && tag >=22) || (monat == 12 && tag <=21) ) {auswahl = 11;}
			if ( (monat == 12 && tag >=22) || (monat == 1 && tag <=19) ) {auswahl = 12;}
			get_string(language, auswahl, stern); 
			set_string(wd->tree, ASTROSIGN, stern);
			redraw_wdobj(wd, ASTROSIGN);

			x = (start - jahr) % 12;
			if ((x == 1) || (x == -11)) {auswahl = 13;}
			if (x == 0) {auswahl = 14;}
			if ((x == 11) || (x == -1)) {auswahl = 15;}
			if ((x == 10) || (x == -2)) {auswahl = 16;}
			if ((x == 9) || (x == -3))  {auswahl = 17;}
			if ((x == 8) || (x == -4))  {auswahl = 18;}
			if ((x == 7) || (x == -5))  {auswahl = 19;}
			if ((x == 6) || (x == -6))  {auswahl = 20;}
			if ((x == 5) || (x == -7))  {auswahl = 21;}
			if ((x == 4) || (x == -8))  {auswahl = 22;}
			if ((x == 3) || (x == -9))  {auswahl = 23;}
			if ((x == 2) || (x == -10))  {auswahl = 24;}  
			get_string(language, auswahl, stern); 
			set_string(wd->tree, ASTROCHIN, stern);
			redraw_wdobj(wd, ASTROCHIN);
			break;
		case ASTROAB:
			close = TRUE;
			break;
		case WD_CLOSER :
			close = TRUE;
			break;
	}
	if (obj!=WD_CLOSER)
	{
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
	return close;
}
/* --------------------------------------------------------------------------- */

void calculator_open_cb(WDIALOG *wd)
{
	char	str[10];
/*	strcpy(PendingOp, "");*/
	PendingOp = CALCC;
	/* dynamisches Popup anlegen */
	strcpy(str, "0");
	set_string(calcdial,CALCTEXT, str);
}

int calculator_exit_cb(WDIALOG *wd, int obj)
{
	int	close = FALSE;
	int	y;
	char	s[30];
	
	switch (obj)
	{
		case CALCNULL :
			NumPressed (0);
			break;
		case CALCEINS :
			NumPressed (1);
			break;
		case CALCZWEI :
			NumPressed (2);
			break;
		case CALCDREI :
			NumPressed (3);
			break;
		case CALCVIER :
			NumPressed (4);
			break;
		case CALCFUENF :
			NumPressed (5);
			break;
		case CALCSECHS :
			NumPressed (6);
			break;
		case CALCACHT :
			NumPressed (8);
			break;
		case CALCNEUN :
			NumPressed (9);
			break;
		case CALCSIEBEN :
			NumPressed (7);
			break;
		case CALCPLUS :
			selectedOp = 0;
/*			Operation(mathe[0].zeichen); 
			Operation('+');*/
			Operation(obj);
			break;
		case CALCMINUS :
			selectedOp = 1;
/*			Operation(mathe[1].zeichen); 
			Operation('-');*/
			Operation(obj);
			break;
		case CALCMAL :
			selectedOp = 2;
			Operation(obj);
			break;
		case CALCGET :
			selectedOp = 3;
			Operation(obj);
			break;
		case CALCGLEICH :
			selectedOp = 4;
			Operation(obj);
			break;
		case CALCCE :
			ClearEntry();
			break;
		case CALCC :
			ClearCalc();
			break;
		case CALCCLOSE :
		case WD_CLOSER :
			close = TRUE;
			break;
	}
	if (obj!=WD_CLOSER)
	{
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
		redraw_wdobj(wd, CALCTEXT);
	}
	return close;
}
void ClearEntry (void) {
	calcwert = 0;
	set_long(calcdial, CALCTEXT, calcwert);
	FlagNewNum = TRUE;
}
void ClearCalc (void) {
	Accum = 0;
	PendingOp = CALCC;
	ClearEntry();
}

void NumPressed (int Num) {
	char str1[15]="";
	char str2[15]="";
	if (FlagNewNum) {
		calcwert  = Num;
		FlagNewNum = FALSE;
		set_long(calcdial, CALCTEXT, calcwert);
	}
	else 
	{
		if (calcwert == 0) {
			calcwert = Num;
			set_long(calcdial, CALCTEXT, calcwert);
		} else {
			get_string(calcdial, CALCTEXT, str1);
			ltoa(Num, str2, 16);
			strcat(str1, str2);
			set_string(calcdial,CALCTEXT, str1);
			calcwert = atol(str1);
		}
	}


}
void Operation (int Op) 
{

	if (FlagNewNum && PendingOp != CALCGLEICH);
	else
	{
		FlagNewNum = TRUE;
		if ( PendingOp == CALCPLUS ) {
			Accum += calcwert;
		} else if ( PendingOp == CALCMINUS) {
			Accum -= calcwert;
		} else if ( PendingOp == CALCGET ) {
			if (calcwert == 0) {
				do_walert(1, 1, rsc_string(DIVBYZERO),  " spareTIME ");
				Accum = calcwert;
				selectedOp = 4;
/*				strcpy(Op, "=");*/
			} else  {
				Accum /= calcwert;
			}
		} else if ( PendingOp == CALCMAL ) {
			Accum *= calcwert;
		} else {
			Accum = calcwert;
		}
		calcwert = Accum;
		PendingOp = Op;
    }
	set_long(calcdial, CALCTEXT, calcwert);
}

/* --------------------------------------------------------------------------- */
int fsel_cb(char *path, char *name)
{
/* hier laufen die Dateinamen/Pfade bei einer Mehrfach-Dateiselektion auf */
/* wird solange von select_file() aufgerufen, wie TRUE zurueckgegeben wird. */

	return TRUE;
}

/* --------------------------------------------------------------------------- */
void handle_menu(int title, int item)
{
	switch (item)
	{
		case MABOUT :
			open_wdial(about_wdial, -1, -1);
			break;
		case MENDE :
			quit = TRUE;
			break;

		case MCALC :
			open_wdial(calc_wdial, -1, -1);
			break;
		case MASTRO :
			open_wdial(astro_wdial, -1, -1);
			break;
		case MEQUA :
			open_wdial(equa_wdial, -1, -1);
			break;
	}
	menu_tnormal(menu, title, 1);
}

static void handle_msg(int *msg)
{
	if (!message_wdial(msg))
	{
		switch (msg[0])
		{
			case MN_SELECTED:
				handle_menu(msg[3], msg[4]);
				break;

			case WM_CLOSED :
			case WM_BOTTOMED:
			case WM_REDRAW:
			case WM_NEWTOP:
			case WM_TOPPED:
			case WM_MOVED:
			case WM_SIZED :
				win_msg(msg);
				break;

			case AP_TERM :
				quit = TRUE;
				break;
		}
	}
}
/* --------------------------------------------------------------------------- */

int main(void)
{
	OBJECT	*tree;
	char		tmp[20];
	ULONG crdate;
	int is_scroll;
    OBSPEC trara;
	char titname[255],path[255];
	WORD	ok;
	int		breite;
	char tmplt[TLEN+1];
#ifdef __MTAES__
	GRECT		n = {0,0,0,0};
	EVNTDATA	ev;
#endif
	
	init_app("sparcalc.rsc");

	rsrc_gaddr(R_TREE, MENUTREE, &menu);
	create_menu(menu);

	rsrc_gaddr(R_TREE, WINICON, &wicon);
	rsrc_gaddr(R_TREE, CALCULATOR, &calcdial);
	fix_dial(calcdial);
	calc_wdial = create_wdial(calcdial, wicon, 0, calculator_open_cb, calculator_exit_cb);

	rsrc_gaddr(R_TREE, ASTRO, &astrodial);
	fix_dial(astrodial);
	astro_wdial = create_wdial(astrodial, wicon, 0, astro_open_cb, astro_exit_cb);

	rsrc_gaddr(R_TREE, ABOUT, &about);
	fix_dial(about);
	about_wdial = create_wdial(about, wicon, 0, about_open_cb, about_exit_cb);

	rsrc_gaddr(R_TREE, EQUA, &equa);
	fix_dial(equa);
	equa_wdial = create_wdial(equa, wicon, 0, equa_open_cb, equa_exit_cb);

	rsrc_gaddr(R_TREE, DISHARE, &sharew);
	fix_menu(sharew);
	sharew_dial = create_wdial(sharew, wicon, 0, WOCB_NULL, sharew_exit_cb);

	rsrc_gaddr(R_TREE, LANGUAGE, &language);
	fix_dial(language);

	/* Callback fuer modale Fensterdialoge, Fenster-Alerts usw. */
	set_mdial_wincb(handle_msg);
	rsrc_gaddr(R_TREE, ASTRO, &astrodial);

	breite = calcdial[0].ob_width;
	quit = FALSE;
	if (breite>253) {
		quit = TRUE;
	}
	while (!quit)
	{
		mbutton = 0;
#ifdef __MTAES__
		event = evnt_multi(MU_MESAG|MU_BUTTON|MU_KEYBD,
									1, 1, 1, 
									0, &n, 0, &n,
									msg,
									0,
									&ev,
									&kreturn, &mclick);
		msx = ev.x;
		msy = ev.y;
		mbutton = ev.bstate;
		kstate = ev.kstate;
#else
		event = evnt_multi(MU_MESAG|MU_BUTTON|MU_KEYBD,
									1, 1, 1, 
									0, 0, 0, 0, 0,
									0, 0, 0, 0, 0,
									msg, 0,
									&msx, &msy, &mbutton, &kstate,
									&kreturn, &mclick);
#endif

		if (event & MU_MESAG) 
			handle_msg(msg);

		if (event & MU_BUTTON) 
		{
			if (!click_wdial(mclick, msx, msy, kstate, mbutton))
				;
		}		
		if (event & MU_KEYBD)
		{
			if (!key_wdial(kreturn, kstate))
			{
				int	title, item;
				
				if (is_menu_key(kreturn, kstate, &title, &item))
					handle_menu(title, item);
			}
		}
	} 
	delete_wdial(calc_wdial);	
	wind_close(win_handle);
	wind_delete(win_handle);
	v_clsvwk(vdi_handle);
	
	delete_menu();
	exit_app(0);
	return 0;
}
