/*
** Kohl-Emulator
** written by Mia Jaap
**
** partly based on the Hellow World application by Ullrich von Bassewitz 
**
*/



#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <joystick.h>



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



static const char Text [] = " Kohl-Emulator ";
const char* firstpart[]={
"die tiefe Einsicht", "die eindeutige Erkenntnis", "die einfache Absicht",
"die hohe Amtspflicht", "die geschichtliche Aufgabe", "den unbedingten Willen", 
"die tiefe Einsicht", "die schlichte Notwendigkeit", "die unerwartete Gnade"
};
const char* secondpart[]={
"hier und jetzt", "notfalls im Alleingang", "gemeinsam miteinander ", 
"in Gut und Boese", "auch gegen den Zeitgeist", "ganz unmissverstaendlich", 
"gegen alle Widerstaende", "in aller Offenheit"
};
const char* thirdpart[]={
"letztlich allein zu sein.", "kraftvoll zuzupacken", "nach vorne zu blicken", 
"kraftvoll zuzupacken", "einfach nach oben zu blicken", "die Kontinuitaet zu wahren", 
"ganz bewusst deutsch zu sein", "dem Vaterland zu dienen", "das Ziel anzustreben", "die Kontinuitaet zu wahren"
};
#define KOHLSAID "Kohl sagte einst... " 
#define PHRASE_INTRO "Wir haben "
#if defined(__NES__) || defined(__PCE__) || defined(__GAMATE__) || defined(__ATARI5200__)
#define END_AGAIN "Button: Noch ein Satz"
#else
#define END_AGAIN "Beenden (J/Y)?"
#endif


/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



int main (void)
{
    unsigned char XSize, YSize;
    int x;
    int stop_emulator=0;
    int randomSeed=15;
    char c,color_bg,color_text,color_border;

    /* Set screen colors */
#if defined(__PCE__)
    color_text = textcolor (COLOR_LIGHTBLUE);
    color_border = bordercolor (COLOR_BLACK);
    color_bg = bgcolor (COLOR_BLACK);
#elif defined(__GAMATE__) || defined(__PET__)
    color_text = textcolor (COLOR_BLACK);
    color_border = bordercolor (COLOR_WHITE);
    color_bg = bgcolor (COLOR_WHITE);
#else
    color_text = textcolor (COLOR_WHITE);
    color_border = bordercolor (COLOR_BLUE);
    color_bg = bgcolor (COLOR_BLUE);
#endif

    do {
        /* Clear the screen, put cursor in upper left corner */
        clrscr ();
        gotoxy (0, 0);

        /* Ask for the screen size */
        screensize (&XSize, &YSize);

        /* Draw a border around the screen */

        /* Top line */
        cputc (CH_ULCORNER);
        chline (XSize - 2);
        cputc (CH_URCORNER);

        /* Vertical line, left side */
        cvlinexy (0, 1, YSize - 2);

        /* Bottom line */
        cputc (CH_LLCORNER);
        chline (XSize - 2);
        cputc (CH_LRCORNER);

        /* Vertical line, right side */
        cvlinexy (XSize - 1, 1, YSize - 2);

        /* Title */
        gotoxy ((XSize - strlen (Text)) / 2, 0);
        cprintf ("%s", Text);
        gotoxy (2, YSize / 2-4);
        cprintf (KOHLSAID);

#if !defined(__PCE__) && !defined(__ATMOS__)
        _randomize();
#endif
        x=rand()%8;
#if defined(__NES__) || defined(__GAMATE__) || defined(__ATARI5200__)
        gotoxy (2, YSize / 2-3);
        cprintf("%s ", PHRASE_INTRO);
        gotoxy (2, YSize / 2-2);
        cprintf("%s ", firstpart[x]);
#else
        gotoxy (2, YSize / 2-2);
        cprintf("%s%s", PHRASE_INTRO,firstpart[x]);
#endif
        x=rand()%8;
        gotoxy (2, YSize / 2-1);
        cprintf("%s", secondpart[x]);
        x=rand()%9;
        gotoxy (2, YSize / 2);
        cprintf("%s", thirdpart[x]);

        gotoxy ((XSize - strlen (END_AGAIN)) / 2, YSize / 2+2);
        cprintf(END_AGAIN);

#if defined(__NES__) || defined(__PCE__) || defined(__GAMATE__) || defined(__ATARI5200__)

        /* Wait for the user to press a button */
        joy_install (joy_static_stddrv);
        while (!joy_read (JOY_1)) ;
        joy_uninstall ();

#else

        /* Wait for the user to press a key */
         c = cgetc();
         if (c=='y' || c=='Y' || c=='J' || c=='j') stop_emulator=1;
#endif
    } while(stop_emulator==0);

    /* Clear the screen again */
#if defined(__C64__)
    color_text = textcolor (COLOR_LIGHTBLUE);
    color_border = bordercolor (COLOR_LIGHTBLUE);
    color_bg = bgcolor (COLOR_BLUE);
#endif
    clrscr ();
    /* Done */
    return EXIT_SUCCESS;
}
