/*
   f98ip.c for fbbi.c
   FBBI's Funge-98 Instruction Pointer - source.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#include <stdio.h>
#include <stdlib.h>

#include "fbbi.h"
#include "bf98spc.h"
#include "f98stack.h"
#include "f98ip.h"

ip * ip_alloc(bfspace * bs, int ssize, int sssize)
{
  int k, j;
  ip * i;
  i = (ip *)malloc(sizeof(ip));
  if (i != NULL)
  {
    i->sm=i->pm=i->hm=0; /* initfields */ i->dx=1;
    i->ir=i->y=i->dy=i->sx=i->sy=i->a=i->b=0;i->x=-1;
    i->bs = bs; i->ssize = ssize; i->sssize = sssize;
    i->s2 = (void *)stack_alloc(sssize, sizeof(stack));
    stack_stack_push((stack *)i->s2, stack_alloc(ssize, sizeof(cell)));
    for (k=0;k<26;k++)
    {
      i->finglev[k] = 0;
      for (j=0;j<26;j++) i->fingins[k][j] = NULL;
    }
  }
  return i;
}

extern void ip_free(ip * i)
{
  stack * x;
  while(stack_measure((stack *)i->s2))
  {
    x = stack_pop((stack *)i->s2);
    if (x != NULL) stack_free(x);
  }
  stack_free((stack *)i->s2);
  free(i);
}

void ip_reverse(ip * i)
{
  NEG(i->dx);  NEG(i->dy);
}

void ip_march(ip * i)
{
  i->x += i->dx;
  i->y += i->dy;
}

void ip_backtrack(ip * i)
{
  ip_reverse(i);
  ip_march(i);

  while (bfspace_inbounds(i->bs, i->x, i->y))
    ip_march(i);

  ip_reverse(i);
  ip_march(i);
}

void ip_advance(ip * i)
{
  ip_march(i);
  if (!bfspace_inbounds(i->bs, i->x, i->y))
    ip_backtrack(i);
}

void ip_skipto(ip * i, cell target)
{
  ip_advance(i);
  while (bfspace_fetch(i->bs, i->x, i->y) != target)
  {
    ip_advance(i);
    #ifndef FBBI_MINIMAL
    if (!fast) printf(" \b");
    #endif
  }
}

void ip_move(ip * i)
{
  ip_advance(i);
  while ((bfspace_fetch(i->bs, i->x, i->y) == (cell)';') && (!i->sm))
  {
    ip_skipto(i, (cell)';'); ip_advance(i);
  }
  while (bfspace_fetch(i->bs, i->x, i->y) == (cell)' ')
  {
#ifndef FBBI_MINIMAL
    if (((i->sm) && (i->pm == 0)) || (b93))
#else
    if ((i->sm) && (i->pm == 0))
#endif
    {
#ifndef FBBI_MINIMAL
      if (!b93)
#endif
        i->pm = 1;
      return;
    }
    ip_advance(i);
#ifndef FBBI_MINIMAL
    if (!fast) printf(" \b");
#endif
    if ((bfspace_fetch(i->bs, i->x, i->y) == (cell)';') && (!i->sm))
    {
      ip_skipto(i, (cell)';'); ip_advance(i);
    }
  }
  i->pm = 0;
}

/* might return NULL */
void * ip_stack(ip * i)
{
  return (stack *)stack_read((stack *)i->s2, 0);
}

cell ip_pop(ip * i)
{
  cell * x;
  stack * s = (stack *)ip_stack(i);
  if (s != NULL)
  {
    x = (cell *)stack_pop(s);
    if (x != NULL) return *x; else return (cell)0;
  } else return (cell)0;
}

int ip_push(ip * i, cell x)
{
  stack * s = (stack *)stack_read((stack *)i->s2, 0);

  if (s != NULL)
  {
    stack_push(s, &x); 
    return 1;
  } else return 0;
}

int ip_clearstack(ip * i)
{
  stack * s = ip_stack(i);
  if (s != NULL)
  {
    stack_clear(s); 
    return 1;
  } else return 0;
}

cell ip_popoffset(ip * i, int offset)
{
  void * x = stack_stack_popoffset((stack *)i->s2, offset);
  if (x != NULL) return *(cell *)x; else return 0;
}

void ip_pushoffset(ip * i, int offset, cell value)
{
  stack_stack_pushoffset((stack *)i->s2, offset, &value);
}

int ip_allocstack(ip * i)
{
  return stack_stack_push((stack *)i->s2, stack_alloc(i->ssize, sizeof(cell)));
}

void ip_freestack(ip * i)
{
  stack * x = stack_stack_pop((stack *)i->s2);
  if (x != NULL) stack_free(x);
}

int ip_transfer(ip * i, int val)
{
  cell zero = (long)0;
  return stack_stack_transfer((stack *)i->s2, val, &zero);
}

void ip_pop_string(ip * i, char * s)
{
  stack_pop_string(stack_stack_top((stack *)i->s2), s);
}

void ip_push_string(ip * i, char * s)
{
  stack_push_string(stack_stack_top((stack *)i->s2), s);
}

int ip_stack_measure(ip * i)
{
  return stack_measure(stack_stack_top((stack *)i->s2));
}

int ip_stacks_measure(ip * i)
{
  return stack_measure((stack *)i->s2);
}

int ip_stack_measure_offset(ip * i, int offset)
{
  stack * s = stack_read((stack *)i->s2, offset);
  if (s != NULL) return stack_measure(s); else return 0;
}

cell ip_stack_peek(ip * i, int offset)
{
  cell * x;
  stack * s = stack_stack_top((stack *)i->s2);
  if (s != NULL)
  {
    x = stack_read(s, offset);
    if (x != NULL) return *(cell *)x; else return 0;
  } else return 0;
}

cell ip_stack_peek_peek(ip * i, int o1, int o2)
{
  cell * x;
  stack * s = (stack *)stack_read((stack *)i->s2, o1);
  if (s != NULL)
  {
    x = stack_read(s, o2);
    if (x != NULL) return *(cell *)x; else return (cell)0;
  } else return 0;
}
