/*
   f98fp.c for fbbi.c
   Funge-98 Fingerprints - source.
   v0.98 Oct 1 1998 Chris Pressey
   Copyunder (u)1998 Cat's-Eye Technologies, http://www.cats-eye.com/
   See http://www.cats-eye.com/license/ for license information.
*/

#include <stdio.h>

#include "fbbi.h"
#include "bf98spc.h"
#include "f98ip.h"
#include "f98i.h"
#include "f98fp.h"
#include "fp/index.h"

cell get_fingerprint(ip * i)
{
  i->b = 0;
  i->a = ip_pop(i);
  for(;i->a;i->a--)
  {
    i->b <<= 8;
    i->b += ip_pop(i);
  }
  return i->b;
}

#ifndef FBBI_MINIMAL

void save_semantics(ip * i, char c) /* save the semantics of instruction c */
{
  if ((c >= 'A') && (c <= 'Z') && (i->finglev[c-'A'] > 0))
    i->fingins[c-'A'][++i->finglev[c-'A']] = instable[c-' '];
}

void restore_semantics(ip * i, char c) /* restore the last saved semantics of c */
{
  if ((c >= 'A') && (c <= 'Z') && (i->finglev[c-'A'] > 0))
    instable[c-' '] = i->fingins[c-'A'][i->finglev[c-'A']--];
}

void bind_semantics(ip * i, char c, void (*b)(ip *)) /* bind c to b() */
{
  instable[c-' '] = b;
  i = i;
}

void overload_semantics(ip * i, char c, void (*b)(ip *)) /* save c, bind c to b() */
{
  save_semantics(i, c);
  bind_semantics(i, c, b);
}

int fingerprint_semantics(ip * i, cell fp, int load)
{
  int k=0;
  if (fp==0) return 0;
  while(1)
  {
    if (library[k].fingerprint == fp)
    {
      library[k].semantics(i, load);
      return 1;
    }
    if (!library[k++].fingerprint) break;
  }
  return 0;
}

#endif
