/*
 * ECI using the  CF-Lib
 */
#include <cflib.h>
#include <stdio.h>
#include <math.h>

#include <string.h>
#include "eci.rsh"
#ifndef FALSE
#define FALSE	0
#define TRUE	1
#endif
#define EOS                '\0'  /* End of string                  */
#define TLEN	255
#define rsc_string(a) (char *) get_obspec(language, a)

#ifdef __MTAES__
#define wind_create_grect(a,b)	wind_create(a,b)
#define wind_calc_grect(a,b,c,d)	wind_calc(a,b,c,d)
#define wind_open_grect(a,b)		wind_open(a,b)
#define wind_set_str(a,b,c)		wind_set_string(a,b,c)
extern int rc_intersect(GRECT *r1, GRECT *r2);
#endif


/* --------------------------------------------------------------------------- */
OBJECT	*menu, *ecidial, *wicon, *popups, *about;
WDIALOG	 *eci_wdial, *about_wdial;
int screen_colors;
int		quit;
int		msg[8], vdi_handle;
int		event, msx, msy, mbutton, kstate, mclick, kreturn, win_handle;
int		modal = FALSE;
long 	Accum = 0;

    char* Feld[]={
          "Absolut", "Array", "Algorithmic", "Analyzer",
          "Basic", "Block", "Bidirectional", "Boot",
          "Color", "Character", "Compacted", "Code",
          "Dimension", "Device", "Digital", "Data",
          "Enhanced", "Error", "Editor", "Emulator",
          "Floating", "Freezer", "Frame", "Feature",
          "Graphics", "Gate", "Global", "Garbage",
          "Help", "Hardware", "Horizontal", "Header",
          "Icon", "Interpreter", "Integrated", "Index",
          "Joined", "Jump", "Job", "Joystick",
          "Keypressed", "Kilobyte", "Kernal", "Konverter",
          "Logical", "Line", "Loader", "Local",
          "Modular", "Memory", "Manager", "Mailbox",
          "Non-Maskable", "Number", "Network", "Numlock",
          "Operating", "Overflow", "Output", "Optical",
          "Processing", "Program", "Parameter", "Plugin",
          "Quick", "Quantity", "Query", "Queue",
          "Relative", "Rotation", "Request", "Random",
          "Serial", "Syntax", "Server", "Scanner",
          "Temporary", "Target", "Transfer", "Task",
          "Universal", "User", "Utility", "Update",
          "Virtual", "Video", "Virus", "Vector",
          "Windowing", "Word", "Writer", "Wafer",
          "X-Ternal", "X-Pand", "X-Tender", "X-Tender",
          "Y-Pand", "Y-Tender", "Y-Ternal", "Y-Ternal",
          "Zero", "Zoom", "Zone", "Zone"
      };
static void handle_msg(int *msg);

void call_guide(WDIALOG *wd,int obj,char *seite);

/* --------------------------------------------------------------------------- */
/* 
 * Ein Dummy-Fenster, dass einfach nur da ist, damit man sieht, dass bei 
 * app-modalen Dialogen Redraw-, Move- und Size-Aktionen ausgewertet 
 * werden.
*/
void redraw_win(int handle, int xc, int yc, int wc, int hc)
{
	GRECT	t1,t2;
	int	temp[4];
	
	hide_mouse();
	wind_update(TRUE);
	t2.g_x = xc; t2.g_y = yc; t2.g_w = wc; t2.g_h = hc;
	wind_get_grect(handle, WF_FIRSTXYWH, &t1);
	vsf_color(vdi_handle, 0);

	wind_get(handle, WF_WORKXYWH, &temp[0], &temp[1], &temp[2], &temp[3]);
	temp[2] += temp[0] - 1;
	temp[3] += temp[1] - 1;

	while (t1.g_w && t1.g_h)
	{
		if (rc_intersect(&t2, &t1))
		{
			set_clipping(vdi_handle, t1.g_x, t1.g_y, t1.g_w, t1.g_h, TRUE);
			v_bar(vdi_handle, temp);
		}
		wind_get(handle, WF_NEXTXYWH, &t1.g_x, &t1.g_y, &t1.g_w, &t1.g_h);
	}
	wind_update(FALSE);
	show_mouse();
}

void win_msg(int *msg)
{
	if (msg[3] == win_handle)
	{
		switch (msg[0])
		{
			case WM_CLOSED :
				wind_close(win_handle);
				break;
			case WM_BOTTOMED:
				wind_set(win_handle, WF_BOTTOM, 0, 0, 0, 0);
				break;
			case WM_REDRAW:
				redraw_win(win_handle, msg[4], msg[5], msg[6], msg[7]);
				break;
			case WM_NEWTOP:
			case WM_TOPPED:
				wind_set(win_handle, WF_TOP, 0, 0, 0, 0);
				break;
			case WM_MOVED:
				wind_set(win_handle, WF_CURRXYWH, msg[4], msg[5], msg[6], msg[7]);
				break;
			case WM_SIZED:
				wind_set(win_handle, WF_CURRXYWH, msg[4], msg[5], msg[6], msg[7]);
				break;
		}
	}
}

/* --------------------------------------------------------------------------- */

void about_open_cb(WDIALOG *wd)
{
}
int about_exit_cb(WDIALOG *wd, int obj)
{
	int	close = FALSE;
	switch (obj)
	{
		case DICALCOK :
		case WD_CLOSER :
			close = TRUE;
			break;
	}
	if (obj!=WD_CLOSER)
	{
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
	return close;
}
/* --------------------------------------------------------------------------- */


void call_guide(WDIALOG *wd,int obj,char *seite)
{
	char	hyp[80];
	int		id;
	strcpy(hyp, "*:\\eci.hyp ");
	strcat(hyp, seite);
	id = appl_find("ST-GUIDE");
	if (id > 0)
		send_vastart(id, hyp);
	if (obj>0) {
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
}

/* --------------------------------------------------------------------------- */


void eci_open_cb(WDIALOG *wd)
{

}
int eci_exit_cb(WDIALOG *wd, int obj)
{
	int	close = FALSE;
	char  abbrev[5];
	int	x,y;
	int i,ascii,eci_currentobj;
	char stern[10];

	switch (obj)
	{
		case ECIOK:
			get_string(wd->tree,ECIWORD,abbrev);
			eci_currentobj=5;
        for (i=0; i<strlen(abbrev); i++) {
          x=rand()%4;
          ascii = ((int) toupper(abbrev[i])-65)*4+x;
          if (ascii>-1 && ascii<95) {
					set_string(wd->tree, eci_currentobj, Feld[ascii]);
					redraw_wdobj(wd, eci_currentobj);
					eci_currentobj++;
          }
          /* A = 65 B 4-7  0*4+rand  C 8-11  2*4+rand*/
        }
			break;
		case ECIAB:
			close = TRUE;
			break;
		case WD_CLOSER :
			close = TRUE;
			break;
	}
	if (obj!=WD_CLOSER)
	{
		set_state(wd->tree, obj, SELECTED, FALSE);
		redraw_wdobj(wd, obj);
	}
	return close;
}


/* --------------------------------------------------------------------------- */
int fsel_cb(char *path, char *name)
{
/* hier laufen die Dateinamen/Pfade bei einer Mehrfach-Dateiselektion auf */
/* wird solange von select_file() aufgerufen, wie TRUE zurueckgegeben wird. */

	return TRUE;
}

/* --------------------------------------------------------------------------- */
void handle_menu(int title, int item)
{
	switch (item)
	{
		case MABOUT :
			open_wdial(about_wdial, -1, -1);
			break;
		case MENDE :
			quit = TRUE;
			break;

		case MECI :
			open_wdial(eci_wdial, -1, -1);
			break;

	}
	menu_tnormal(menu, title, 1);
}

static void handle_msg(int *msg)
{
	if (!message_wdial(msg))
	{
		switch (msg[0])
		{
			case MN_SELECTED:
				handle_menu(msg[3], msg[4]);
				break;

			case WM_CLOSED :
			case WM_BOTTOMED:
			case WM_REDRAW:
			case WM_NEWTOP:
			case WM_TOPPED:
			case WM_MOVED:
			case WM_SIZED :
				win_msg(msg);
				break;

			case AP_TERM :
				quit = TRUE;
				break;
		}
	}
}
/* --------------------------------------------------------------------------- */

int main(void)
{
	OBJECT	*tree;
	char		tmp[20];
	ULONG crdate;
	int is_scroll;
    OBSPEC trara;
	char titname[255],path[255];
	WORD	ok;
	int		breite;
	char tmplt[TLEN+1];
#ifdef __MTAES__
	GRECT		n = {0,0,0,0};
	EVNTDATA	ev;
#endif
	
	init_app("eci.rsc");

	rsrc_gaddr(R_TREE, MENUTREE, &menu);
	create_menu(menu);

	rsrc_gaddr(R_TREE, WINICON, &wicon);
	rsrc_gaddr(R_TREE, ECIDIAL, &ecidial);
	fix_dial(ecidial);
	eci_wdial = create_wdial(ecidial, wicon, 0, eci_open_cb, eci_exit_cb);

	rsrc_gaddr(R_TREE, ABOUT, &about);
	fix_dial(about);
	about_wdial = create_wdial(about, wicon, 0, about_open_cb, about_exit_cb);

;

	/* Callback fuer modale Fensterdialoge, Fenster-Alerts usw. */
	set_mdial_wincb(handle_msg);

	while (!quit)
	{
		mbutton = 0;
#ifdef __MTAES__
		event = evnt_multi(MU_MESAG|MU_BUTTON|MU_KEYBD,
									1, 1, 1, 
									0, &n, 0, &n,
									msg,
									0,
									&ev,
									&kreturn, &mclick);
		msx = ev.x;
		msy = ev.y;
		mbutton = ev.bstate;
		kstate = ev.kstate;
#else
		event = evnt_multi(MU_MESAG|MU_BUTTON|MU_KEYBD,
									1, 1, 1, 
									0, 0, 0, 0, 0,
									0, 0, 0, 0, 0,
									msg, 0,
									&msx, &msy, &mbutton, &kstate,
									&kreturn, &mclick);
#endif

		if (event & MU_MESAG) 
			handle_msg(msg);

		if (event & MU_BUTTON) 
		{
			if (!click_wdial(mclick, msx, msy, kstate, mbutton))
				;
		}		
		if (event & MU_KEYBD)
		{
			if (!key_wdial(kreturn, kstate))
			{
				int	title, item;
				
				if (is_menu_key(kreturn, kstate, &title, &item))
					handle_menu(title, item);
			}
		}
	} 
	delete_wdial(eci_wdial);	
	wind_close(win_handle);
	wind_delete(win_handle);
	v_clsvwk(vdi_handle);
	
	delete_menu();
	exit_app(0);
	return 0;
}
