/* erzeugt mit RSM2CS V1.01 Beta von Armin Diedering aus "E:\pc\cflib-12\eci\deutsch\eci.rsc" */
/* nach Sourcen von Holger Weets */

#include <portab.h>

static char rs_s0[] = "";
static char rs_s2[] = "OK";
static char rs_s1[] = "              ";

static char rs_s3[] = "";
static char rs_s4[] = "";
static char rs_s5[] = "";
static char rs_s6[] = "";
static char rs_s7[] = "";

#define FLAGS11 0x0800
#define FLAGS12 0x1000
#define FLAGS13 0x2000
#define FLAGS14 0x4000
#define FLAGS15 0x8000
#define STATE8  0x0100
#define STATE9  0x0200
#define STATE10 0x0400
#define STATE11 0x0800
#define STATE12 0x1000
#define STATE13 0x2000
#define STATE14 0x4000
#define STATE15 0x8000

#define RS_NTED 9

static TEDINFO rs_tedinfo[] = {
	"2.40     ",
	rs_s0,
	rs_s0,
	IBM, 6, TE_LEFT, 4736, 0, -1, 10, 1,

	"Datum:   16.03.2020 ",
	rs_s0,
	rs_s0,
	IBM, 6, TE_LEFT, 4480, 0, -1, 21, 1,

	"WWW:     https://www.mia-jaap.de/",
	rs_s0,
	rs_s0,
	IBM, 6, TE_LEFT, 4480, 0, -1, 34, 1,

	"Atari ST version by Mia Jaap.",
	rs_s0,
	rs_s0,
	IBM, 0, TE_LEFT, 5376, 0, 0, 30, 1,

	"Original MS-DOS version by",
	rs_s0,
	rs_s0,
	IBM, 0, TE_LEFT, 5888, 0, 0, 27, 1,

	"O. Buschek & B. Wilpert (1989)",
	rs_s0,
	rs_s0,
	IBM, 0, TE_LEFT, 7936, 0, 0, 31, 1,

	"Written in C + cflib",
	rs_s0,
	rs_s0,
	IBM, 0, TE_LEFT, 4352, 0, 0, 21, 1,

	"- Freeware -",
	rs_s0,
	rs_s0,
	IBM, 0, TE_LEFT, 4352, 0, 0, 13, 1,

	"\0@@@@",
	"_____",
	"A",
	IBM, 0, TE_LEFT, 4480, 0, -2, 6, 6
};

static int rs_b27img[] = {
	0x0000,0x0000,0x0000,0x0000,0x01ff,0xffe0,0x3fff,0xffff,
	0x7fff,0xffff,0xffff,0xffff,0x7fff,0xffff,0x3fff,0xffff,
	0x01ff,0xffe0,0x01ff,0xffe0,0x01ff,0xffe0,0x03ff,0xffc0,
	0x03ff,0xffe0,0x03ff,0xffe0,0x03ff,0xffe0,0x03ff,0xffe0,
	0x03ff,0xffe0,0x03ff,0xffe0,0x03ff,0xfff0,0x03ff,0xfff0,
	0x03ff,0xffe0,0x03ff,0xfff8,0x03ff,0xfff8,0x00ff,0xfff8,
	0x01ff,0xfffc,0x01ff,0xfffc,0x01ff,0xffe0,0x01ff,0xfe00,
	0x00ff,0x8000,0x00fc,0x0000,0x0070,0x0000,0x0000,0x0000
};

static int rs_b26img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0c00,0x000d,
	0x407f,0xfff0,0xc980,0x0001,0x477f,0xffe7,0x1c00,0x000d,
	0x007f,0xffc0,0x0080,0x0340,0x00c0,0x1440,0x0080,0x29c0,
	0x0135,0x1000,0x001d,0x0040,0x0000,0x5040,0x0014,0x5040,
	0x0008,0x0040,0x0012,0x0040,0x0000,0x0c20,0x0000,0xc620,
	0x0005,0x0060,0x000a,0x4000,0x00c4,0x0010,0x0080,0x0010,
	0x0000,0x0008,0x0000,0x0020,0x0000,0x0200,0x0000,0x8000,
	0x0004,0x0000,0x0010,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3eff,0xffef,
	0x7f00,0x0007,0xffbf,0xfff7,0x7f7f,0xffef,0x3e00,0x000f,
	0x00ff,0xffc0,0x00ff,0xffc0,0x00ff,0xffc0,0x00f5,0xffc0,
	0x01ff,0xffc0,0x01bf,0xdfc0,0x01fd,0xffc0,0x01ff,0xffc0,
	0x01ff,0xdfc0,0x01fb,0xfdc0,0x01ff,0xffe0,0x01ff,0xefe0,
	0x01ff,0xffe0,0x01ff,0xffe0,0x00ff,0xfff0,0x00ff,0xfff0,
	0x00ff,0xfff8,0x00ff,0xffe0,0x00ff,0xfe00,0x00ff,0x8000,
	0x007c,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01ff,0xffe0,0x3100,0x0010,
	0x7fff,0xfffe,0xf040,0x0008,0x70ff,0xfff0,0x21ff,0xfff0,
	0x017f,0xffe0,0x0180,0x0360,0x01c0,0x1460,0x038a,0x29c0,
	0x0335,0x1020,0x025d,0x2060,0x0202,0x5060,0x0214,0x5060,
	0x0208,0x2060,0x0216,0x0260,0x0200,0x0c30,0x0200,0xd630,
	0x0205,0x0060,0x020a,0x4018,0x03c4,0x0018,0x0080,0x0018,
	0x0100,0x000c,0x0100,0x003c,0x0100,0x03e0,0x0100,0xfe00,
	0x0087,0x8000,0x009c,0x0000,0x0070,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x30ff,0xffe0,
	0x7f00,0x0006,0xf03f,0xfff0,0x707f,0xffe0,0x2000,0x0000,
	0x00ff,0xffc0,0x00ff,0xfcc0,0x00ff,0xebc0,0x00f5,0xd6c0,
	0x01ca,0xefc0,0x01a2,0xdfc0,0x01fd,0xafc0,0x01eb,0xafc0,
	0x01f7,0xdfc0,0x01e9,0xfdc0,0x01ff,0xf3e0,0x01ff,0x29e0,
	0x01fa,0xffe0,0x01f5,0xbfe0,0x00fb,0xfff0,0x00ff,0xfff0,
	0x00ff,0xfff8,0x00ff,0xffe0,0x00ff,0xfe00,0x00ff,0x8000,
	0x007c,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0eff,0xffef,
	0x6000,0x0001,0xffbf,0xfff7,0x6f00,0x000f,0x1e00,0x000f,
	0x0080,0x0000,0x007f,0xfc80,0x003f,0xeb80,0x0075,0xd600,
	0x00ca,0xefc0,0x01a2,0xdf80,0x01fd,0xaf80,0x01eb,0xaf80,
	0x01f7,0xdf80,0x01e9,0xfd80,0x01ff,0xf3c0,0x01ff,0x29c0,
	0x01fa,0xff80,0x01f5,0xbfe0,0x003b,0xffe0,0x007f,0xffe0,
	0x00ff,0xfff0,0x00ff,0xffc0,0x00ff,0xfc00,0x00ff,0x0000,
	0x0078,0x0000,0x0060,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01ff,0xffe0,0x31ff,0xfff0,
	0x5fff,0xfffe,0xc07f,0xfff8,0x5080,0x0010,0x21ff,0xfff0,
	0x0180,0x0020,0x017f,0xfca0,0x013f,0xeba0,0x037f,0xd600,
	0x02ca,0xefe0,0x03e2,0xffa0,0x03ff,0xafa0,0x03eb,0xafa0,
	0x03f7,0xffa0,0x03ed,0xffa0,0x03ff,0xf3d0,0x03ff,0x39d0,
	0x03fa,0xff80,0x03f5,0xbff8,0x033b,0xffe8,0x007f,0xffe8,
	0x01ff,0xfff4,0x01ff,0xffdc,0x01ff,0xfde0,0x01ff,0x7e00,
	0x00fb,0x8000,0x00ec,0x0000,0x0070,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x01ff,0xffe0,0x3100,0x0010,
	0x7fff,0xfffe,0xf040,0x0008,0x7080,0x0010,0x21ff,0xfff0,
	0x0100,0x0020,0x0100,0x0020,0x0100,0x0020,0x030a,0x0000,
	0x0200,0x0020,0x0240,0x2020,0x0202,0x0020,0x0200,0x0020,
	0x0200,0x2020,0x0204,0x0220,0x0200,0x0010,0x0200,0x1010,
	0x0200,0x0000,0x0200,0x0018,0x0300,0x0008,0x0000,0x0008,
	0x0100,0x0004,0x0100,0x001c,0x0100,0x01e0,0x0100,0x7e00,
	0x0083,0x8000,0x008c,0x0000,0x0070,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00ff,0xffe0,
	0x607f,0xfff0,0xf03f,0xfff0,0x607f,0xffe0,0x0000,0x0000,
	0x00ff,0xffc0,0x00ff,0xffc0,0x00ff,0xffc0,0x00f5,0xffc0,
	0x01ff,0xffc0,0x01bf,0xdfc0,0x01fd,0xffc0,0x01ff,0xffc0,
	0x01ff,0xdfc0,0x01fb,0xfdc0,0x01ff,0xffe0,0x01ff,0xefe0,
	0x01ff,0xffe0,0x01ff,0xffe0,0x00ff,0xfff0,0x00ff,0xfff0,
	0x00ff,0xfff8,0x00ff,0xffe0,0x00ff,0xfe00,0x00ff,0x8000,
	0x007c,0x0000,0x0070,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b25img[] = {
	0x0000,0x0000,0x3fff,0xfe00,0x2000,0x0300,0x2000,0x0280,
	0x2000,0x0240,0x2000,0x0220,0x2000,0x0210,0x2000,0x03f8,
	0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,
	0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,
	0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,
	0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,
	0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,0x2000,0x0008,
	0x2000,0x0008,0x2000,0x0008,0x3fff,0xfff8,0x0000,0x0000
};

static int rs_b24img[] = {
	0x0000,0x0000,0x3fff,0xfe00,0x3fff,0xff00,0x3fff,0xff80,
	0x3fff,0xffc0,0x3fff,0xffe0,0x3fff,0xfff0,0x3fff,0xfff8,
	0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,
	0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,
	0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,
	0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,
	0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,
	0x3fff,0xfff8,0x3fff,0xfff8,0x3fff,0xfff8,0x0000,0x0000
};

static int rs_b23img[] = {
	0x03ff,0xffe0,0x07ff,0xfff0,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x07ff,0xfff0,
	0x07ff,0xfff0,0x07ff,0xfff0,0x07ff,0xfff0,0x07ff,0xfff0
};

static int rs_b22img[] = {
	0x03ff,0xffe0,0x0400,0x0010,0x0800,0x0008,0x09ff,0xffc8,
	0x0bff,0xffe8,0x0bff,0xffe8,0x0bff,0xffe8,0x0bff,0xffe8,
	0x0bff,0xffe8,0x0bff,0xffe8,0x0bff,0xffe8,0x0bff,0xffe8,
	0x0bff,0xffe8,0x0bff,0xffe8,0x0bff,0xffe8,0x0bfb,0xf768,
	0x0bff,0xffe8,0x09ff,0xffc8,0x0800,0x0008,0x0800,0x0008,
	0x0800,0x0008,0x0800,0x0008,0x0980,0x1f88,0x0800,0x0008,
	0x0800,0x0008,0x0800,0x0008,0x0800,0x0008,0x07ff,0xfff0,
	0x0400,0x0010,0x0400,0x0010,0x0400,0x0010,0x07ff,0xfff0,
	0x03ff,0xffe0,0x07ff,0xfff0,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0e00,0x0038,0x0ef0,0xe238,0x0e81,0x0238,0x0e81,0x0238,
	0x0e81,0x0238,0x0e81,0x0238,0x0ee1,0x0238,0x0e81,0x0238,
	0x0e81,0x0238,0x0e81,0x0238,0x0e81,0x0238,0x0ef4,0xeab8,
	0x0e00,0x0038,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x07ff,0xfff0,
	0x0400,0x0010,0x0400,0x0010,0x0400,0x0010,0x07ff,0xfff0,
	0x03ff,0xffe0,0x07ff,0xfff0,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0f0f,0x1df8,0x0f7e,0xfdf8,0x0f7e,0xfdf8,
	0x0f7e,0xfdf8,0x0f7e,0xfdf8,0x0f1e,0xfdf8,0x0f7e,0xfdf8,
	0x0f7e,0xfdf8,0x0f7e,0xfdf8,0x0f7e,0xfdf8,0x0f0f,0x1df8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x07ff,0xfff0,
	0x07ff,0xfff0,0x07ff,0xfff0,0x07ff,0xfff0,0x07ff,0xfff0,
	0x03ff,0xffe0,0x07ff,0xfff0,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0f0f,0x1df8,0x0f7e,0xfdf8,0x0f7e,0xfdf8,
	0x0f7e,0xfdf8,0x0f7e,0xfdf8,0x0f1e,0xfdf8,0x0f7e,0xfdf8,
	0x0f7e,0xfdf8,0x0f7e,0xfdf8,0x0f7e,0xfdf8,0x0f0b,0x1578,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x07ff,0xfff0,
	0x0400,0x0010,0x0400,0x0010,0x0400,0x0010,0x07ff,0xfff0
};

static int rs_b21img[] = {
	0x03ff,0xffe0,0x0400,0x0010,0x0800,0x0008,0x09ff,0xffc8,
	0x0a00,0x0028,0x0af0,0xe228,0x0a81,0x0228,0x0a81,0x0228,
	0x0a81,0x0228,0x0a81,0x0228,0x0ae1,0x0228,0x0a81,0x0228,
	0x0a81,0x0228,0x0a81,0x0228,0x0a81,0x0228,0x0af4,0xeaa8,
	0x0a00,0x0028,0x09ff,0xffc8,0x0800,0x0008,0x0800,0x0008,
	0x0800,0x0008,0x0800,0x0008,0x0980,0x1f88,0x0800,0x0008,
	0x0800,0x0008,0x0800,0x0008,0x0800,0x0008,0x07ff,0xfff0,
	0x0400,0x0010,0x0400,0x0010,0x0400,0x0010,0x07ff,0xfff0
};

static int rs_b20img[] = {
	0x03ff,0xffe0,0x07ff,0xfff0,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,
	0x0fff,0xfff8,0x0fff,0xfff8,0x0fff,0xfff8,0x07ff,0xfff0,
	0x07ff,0xfff0,0x07ff,0xfff0,0x07ff,0xfff0,0x07ff,0xfff0
};

static int rs_b19img[] = {
	0x0000,0x0000,0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,
	0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,0x003b,0xb800,
	0x003b,0xb800,0x003b,0xb800,0x003b,0xb800,0x007b,0xbc00,
	0x007b,0xbc00,0x00fb,0xbe00,0x01f3,0x9f00,0x03f3,0x9f80,
	0x0fe3,0x8fe0,0x7fc3,0x87fc,0x7f83,0x83fc,0x7e03,0x80fc,
	0x7803,0x803c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b18img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x003b,0xb800,0x003b,0xb800,0x007b,0xbc00,
	0x007b,0xbc00,0x00fb,0xbe00,0x01f3,0x9f00,0x03f3,0x9f80,
	0x0fe3,0x8fe0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,
	0x001b,0xb000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x7fc3,0x87fc,0x7f83,0x83fc,0x7e03,0x80fc,
	0x7803,0x803c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,
	0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,0x003b,0xb800,
	0x003b,0xb800,0x003b,0xb800,0x003b,0xb800,0x007b,0xbc00,
	0x007b,0xbc00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x001b,0xb000,
	0x001b,0xb000,0x0000,0x0000,0x0000,0x0000,0x003b,0xb800,
	0x003b,0xb800,0x003b,0xb800,0x003b,0xb800,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x03f3,0x9f80,
	0x0fe3,0x8fe0,0x7fc3,0x87fc,0x7f83,0x83fc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b17img[] = {
	0x0000,0x0000,0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,
	0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,0x003b,0xb800,
	0x003b,0xb800,0x003b,0xb800,0x003b,0xb800,0x007b,0xbc00,
	0x007b,0xbc00,0x00fb,0xbe00,0x01f3,0x9f00,0x03f3,0x9f80,
	0x0fe3,0x8fe0,0x7fc3,0x87fc,0x7f83,0x83fc,0x7e03,0x80fc,
	0x7803,0x803c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b16img[] = {
	0x0000,0x0000,0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,
	0x001b,0xb000,0x001b,0xb000,0x001b,0xb000,0x003b,0xb800,
	0x003b,0xb800,0x003b,0xb800,0x003b,0xb800,0x007b,0xbc00,
	0x007b,0xbc00,0x00fb,0xbe00,0x01f3,0x9f00,0x03f3,0x9f80,
	0x0fe3,0x8fe0,0x7fc3,0x87fc,0x7f83,0x83fc,0x7e03,0x80fc,
	0x7803,0x803c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b15img[] = {
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000
};

static int rs_b14img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0006,0x0000,0x0008,0x0000,
	0x0010,0x0000,0x0010,0x0800,0x0020,0x0800,0x0020,0x0000,
	0x1fe0,0x0078,0x3fe0,0x038c,0x3020,0x03f0,0x0020,0x03fc,
	0x0020,0x0000,0x0020,0x0000,0x0020,0x0000,0x3f80,0x00fc,
	0x3d00,0x003c,0x2240,0x0004,0x0f60,0x00f8,0x000f,0xf800,
	0x07ff,0xfff8,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ffe,0x0ffc,0x3ff8,0x07fc,
	0x3ff0,0x03fc,0x3ff0,0x0bfc,0x3fe0,0x0bfc,0x3fe0,0x03fc,
	0x3fe0,0x007c,0x2020,0x0384,0x0fe0,0x03f0,0x3820,0x03fc,
	0x03e0,0x01c0,0x3e20,0x017c,0x00e0,0x0000,0x3f80,0x00fc,
	0x3f00,0x00fc,0x2240,0x0004,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x000e,0x0000,0x0008,0x0000,
	0x0030,0x0000,0x0030,0x0800,0x0020,0x0800,0x0020,0x0000,
	0x1fe0,0x0078,0x2020,0x0004,0x0020,0x0000,0x07e0,0x0000,
	0x3fe0,0x01fc,0x3e20,0x017c,0x00e0,0x0000,0x0080,0x0000,
	0x3f00,0x00fc,0x1e40,0x00f8,0x0f60,0x00f8,0x0000,0x0000,
	0x0007,0xf000,0x03ff,0xfff8,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ff9,0xfffc,0x3ff7,0xfffc,
	0x3fef,0xe7fc,0x3fef,0xcffc,0x3fdf,0xeffc,0x3fdf,0xfffc,
	0x3fdf,0xe07c,0x201f,0xc004,0x001f,0x8000,0x001f,0x0000,
	0x001f,0x0300,0x01df,0x0380,0x3fdf,0x03fc,0x3f7f,0x01fc,
	0x3eff,0x01fc,0x3dbf,0xfffc,0x309f,0xff04,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0380,0x1fc0,0x03f8,0x3fc0,0x03fc,0x3fc0,0x03fc,
	0x3fc0,0x00fc,0x3fc0,0x00fc,0x3f00,0x00fc,0x3f00,0x00fc,
	0x3c00,0x003c,0x2000,0x0004,0x001f,0xfc00,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ff0,0x0ffc,0x3ff0,0x07fc,
	0x3fc0,0x03fc,0x3fc0,0x0bfc,0x3fc0,0x0bfc,0x3fc0,0x03fc,
	0x3fc0,0x03fc,0x3fc0,0x03fc,0x3fc0,0x03fc,0x3fc0,0x03fc,
	0x3fc0,0x00fc,0x3fc0,0x00fc,0x3f00,0x00fc,0x3f00,0x00fc,
	0x3c00,0x003c,0x2000,0x0004,0x0000,0x0000,0x0000,0x0000,
	0x0007,0xf000,0x03ff,0xfff8,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0380,0x0000,0x03f0,0x0000,0x03fc,0x0000,0x03fc,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0007,0xf000,0x03ff,0xfff8,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0007,0xf000,0x03ff,0xfff8,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000
};

static int rs_b13img[] = {
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000
};

static int rs_b12img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0006,0x0000,0x0008,0x0000,
	0x0010,0x0000,0x0010,0x0800,0x0020,0x0800,0x0020,0x0000,
	0x0020,0x0380,0x0020,0x03f0,0x0020,0x03fc,0x0020,0x03fc,
	0x0020,0x0000,0x0020,0x0000,0x0020,0x0000,0x0080,0x0000,
	0x0100,0x0000,0x0240,0x0000,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x000e,0x0000,0x0008,0x0000,
	0x0030,0x0000,0x0030,0x0800,0x0020,0x0800,0x0020,0x0000,
	0x0020,0x0280,0x0020,0x0150,0x0020,0x02a8,0x0020,0x0154,
	0x0020,0x0100,0x0020,0x0100,0x00e0,0x0000,0x0080,0x0000,
	0x0300,0x00c0,0x0240,0x0000,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ffe,0x0ffc,0x3ff8,0x07fc,
	0x3ff0,0x03fc,0x3ff0,0x0bfc,0x3fe0,0x0bfc,0x3fe0,0x03fc,
	0x3fe0,0x007c,0x3fe0,0x000c,0x3fe0,0x0000,0x3fe0,0x0000,
	0x3fe0,0x01fc,0x3fe0,0x01fc,0x3fe0,0x00fc,0x3f80,0x00fc,
	0x3f00,0x00fc,0x3e40,0x00fc,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ff9,0xfffc,0x3ff7,0xfffc,
	0x3fef,0xe7fc,0x3fef,0xcffc,0x3fdf,0xeffc,0x3fdf,0xfffc,
	0x3fdf,0xe07c,0x3fdf,0xc00c,0x3fdf,0x8000,0x3fdf,0x0000,
	0x3fdf,0x03fc,0x3fdf,0x03fc,0x3fdf,0x03fc,0x3f7f,0x01fc,
	0x3eff,0x01fc,0x3dbf,0xfffc,0x309f,0xff04,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x001f,0xfc00,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x001f,0xfc00,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x001f,0xfc00,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0800,0x0000,0x0800,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x001f,0xfc00,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000
};

static int rs_b11img[] = {
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000
};

static int rs_b10img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0006,0x0000,0x0008,0x0000,
	0x0010,0x0000,0x0010,0x0800,0x0020,0x0800,0x0020,0x0000,
	0x0020,0x0380,0x0020,0x03f0,0x0020,0x03fc,0x0020,0x03fc,
	0x0020,0x0000,0x0020,0x0000,0x0020,0x0000,0x0080,0x0000,
	0x0100,0x0000,0x0240,0x0000,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x000e,0x0000,0x0008,0x0000,
	0x0030,0x0000,0x0030,0x0800,0x0020,0x0800,0x0020,0x0000,
	0x0020,0x0100,0x0020,0x02a0,0x0020,0x0154,0x0020,0x02a8,
	0x0020,0x0100,0x0020,0x0100,0x00e0,0x0000,0x0080,0x0000,
	0x0300,0x00c0,0x0240,0x0000,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ffe,0x0ffc,0x3ff8,0x07fc,
	0x3ff0,0x03fc,0x3ff0,0x0bfc,0x3fe0,0x0bfc,0x3fe0,0x03fc,
	0x3fe0,0x007c,0x3fe0,0x000c,0x3fe0,0x0000,0x3fe0,0x0000,
	0x3fe0,0x01fc,0x3fe0,0x01fc,0x3fe0,0x00fc,0x3f80,0x00fc,
	0x3f00,0x00fc,0x3e40,0x00fc,0x0f7f,0xfcf8,0x0fff,0xfff8,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3ff9,0xfffc,0x3ff7,0xfffc,
	0x3fef,0xe7fc,0x3fef,0xcffc,0x3fdf,0xeffc,0x3fdf,0xfffc,
	0x3fdf,0xe07c,0x3fdf,0xc00c,0x3fdf,0x8000,0x3fdf,0x0000,
	0x3fdf,0x03fc,0x3fdf,0x03fc,0x3fdf,0x03fc,0x3f7f,0x01fc,
	0x3eff,0x01fc,0x3dbf,0xfffc,0x309f,0xff04,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x0000,0x0000
};

static int rs_b9img[] = {
	0x3fff,0xfffc,0x2000,0x0004,0x200f,0xf004,0x201a,0xbc04,
	0x2035,0x7204,0x206a,0xa604,0x2055,0x6204,0x206a,0xbe04,
	0x2055,0x6b84,0x206a,0xc0f4,0x2055,0x400c,0x206a,0xc004,
	0x2055,0x43fc,0x206a,0xc204,0x20d5,0x4204,0x21aa,0xc204,
	0x2355,0x6104,0x26aa,0xa1c4,0x3d55,0x5b7c,0x2abf,0xfc0c,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc
};

static int rs_b8img[] = {
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3ffa,0xbffc,
	0x3ff5,0x7ffc,0x3fea,0xbffc,0x3fd5,0x7ffc,0x3fea,0xbffc,
	0x3fd5,0x7ffc,0x3fea,0xfffc,0x3fd5,0x7ffc,0x3fea,0xfffc,
	0x3fd5,0x7ffc,0x3fea,0xfffc,0x3fd5,0x7ffc,0x3faa,0xfffc,
	0x3f55,0x7ffc,0x3eaa,0xbffc,0x3d55,0x5ffc,0x2abf,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,
	0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc,0x3fff,0xfffc
};

static int rs_b7img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x00ff,0xffff,0xc000,0x0007,0xff80,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x003f,0xfff0,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x007f,0xfff8,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x00ff,0xfffc,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x01ff,0xfffe,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x03ff,0xffff,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x07ff,0xffff,0x8000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x0fff,0x87ff,0x8000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x0ffe,0x00ff,0x8000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x1ffc,0x001f,0x8000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x1ffc,0x001f,0x8000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x3ff8,0x001f,0x8000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x3ff0,0x001f,0x0000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x3ff0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0x8000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x3fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x1fe0,0x0000,0x0000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x1ff0,0x00ff,0xc000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x1ff0,0x00ff,0xc000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x0ff0,0x00ff,0xc000,0x1ff0,0x0000,
	0x01ff,0x0000,0x0000,0x0ff8,0x01ff,0xc000,0x1ff0,0x0000,
	0x01ff,0x0000,0x03fc,0x0fff,0xc7ff,0xc3fe,0x1ff0,0xff80,
	0x01ff,0xffff,0x83fe,0x07ff,0xffff,0xc3fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x07ff,0xffff,0x83fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x03ff,0xffff,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x01ff,0xffff,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x00ff,0xfffe,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x003f,0xfff8,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x000f,0xfff0,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x0003,0xff80,0x03fe,0x0ff0,0xff80,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b6img[] = {
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x00ff,0xffff,0xc000,0x0007,0xff80,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x003e,0x01f0,0x0000,0x1ff0,0x0000,
	0x0180,0x0000,0xc000,0x0078,0x0038,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x00f0,0x000c,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x01c0,0x0006,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x0303,0xfc03,0x0000,0x1830,0x0000,
	0x0183,0xffff,0xc000,0x0707,0xff01,0x8000,0x1830,0x0000,
	0x0183,0xffff,0xc000,0x0e1f,0x8780,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0c1e,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1c3c,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x183c,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3838,0x001f,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3870,0x001f,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3070,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x0000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1020,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1830,0x00ff,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1830,0x00e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0810,0x00e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0c00,0x01e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x03fc,0x0c07,0xc7c1,0xc3fe,0x1830,0xff80,
	0x0183,0xffff,0x83fe,0x0403,0xffc3,0xc3fe,0x1830,0xff80,
	0x0183,0xffff,0xe306,0x0600,0xfe03,0x8306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0300,0x000f,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0180,0x001f,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x00e0,0x007e,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0038,0x01f8,0x0306,0x1830,0xc180,
	0x01ff,0xffff,0xe3fe,0x000f,0xfff0,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x0003,0xff80,0x03fe,0x0ff0,0xff80,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x00ff,0xffff,0xc000,0x0007,0xff80,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x003e,0x01f0,0x0000,0x1ff0,0x0000,
	0x0180,0x0000,0xc000,0x0078,0x0038,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x00f0,0x000c,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x01c0,0x0006,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x0303,0xfc03,0x0000,0x1830,0x0000,
	0x0183,0xffff,0xc000,0x0707,0xff01,0x8000,0x1830,0x0000,
	0x0183,0xffff,0xc000,0x0e1f,0x8780,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0c1e,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1c3c,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x183c,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3838,0x001f,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3870,0x001f,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3070,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x0000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1020,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1830,0x00ff,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1830,0x00e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0810,0x00e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0c00,0x01e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x03fc,0x0c07,0xc7c1,0xc3fe,0x1830,0xff80,
	0x0183,0xffff,0x83fe,0x0403,0xffc3,0xc3fe,0x1830,0xff80,
	0x0183,0xffff,0xe306,0x0600,0xfe03,0x8306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0300,0x000f,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0180,0x001f,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x00e0,0x007e,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0038,0x01f8,0x0306,0x1830,0xc180,
	0x01ff,0xffff,0xe3fe,0x000f,0xfff0,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x0003,0xff80,0x03fe,0x0ff0,0xff80,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x00ff,0xffff,0xc000,0x0007,0xff80,0x0000,0x1ff0,0x0000,
	0x01ff,0xffff,0xc000,0x003e,0x01f0,0x0000,0x1ff0,0x0000,
	0x0180,0x0000,0xc000,0x0078,0x0038,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x00f0,0x000c,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x01c0,0x0006,0x0000,0x1830,0x0000,
	0x0180,0x0000,0xc000,0x0303,0xfc03,0x0000,0x1830,0x0000,
	0x0183,0xffff,0xc000,0x0707,0xff01,0x8000,0x1830,0x0000,
	0x0183,0xffff,0xc000,0x0e1f,0x8780,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0c1e,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1c3c,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x183c,0x0000,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3838,0x001f,0x8000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3870,0x001f,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3070,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0180,0x0001,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0xffff,0x8000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x3060,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1020,0x0000,0x0000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1830,0x00ff,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x1830,0x00e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0810,0x00e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x0000,0x0c00,0x01e0,0xc000,0x1830,0x0000,
	0x0183,0x0000,0x03fc,0x0c07,0xc7c1,0xc3fe,0x1830,0xff80,
	0x0183,0xffff,0x83fe,0x0403,0xffc3,0xc3fe,0x1830,0xff80,
	0x0183,0xffff,0xe306,0x0600,0xfe03,0x8306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0300,0x000f,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0180,0x001f,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x00e0,0x007e,0x0306,0x1830,0xc180,
	0x0180,0x0000,0x6306,0x0038,0x01f8,0x0306,0x1830,0xc180,
	0x01ff,0xffff,0xe3fe,0x000f,0xfff0,0x03fe,0x1ff0,0xff80,
	0x01ff,0xffff,0xe3fe,0x0003,0xff80,0x03fe,0x0ff0,0xff80,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x4000,0x0000,0x0000,0x0000,0x0010,0x0000,
	0x0000,0x0000,0xc000,0x0001,0xfe00,0x0000,0x0030,0x0000,
	0x007f,0xffff,0xc000,0x0007,0xffc0,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0xc000,0x000f,0xfff0,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0xc000,0x003f,0xfff8,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0xc000,0x00ff,0xfffc,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0xc000,0x00ff,0xfffe,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0xc000,0x01ff,0x87ff,0x8000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x03fe,0x00ff,0x8000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x03fc,0x001f,0x8000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x07fc,0x001f,0x8000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x07f8,0x001f,0x8000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x07f0,0x001f,0x0000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x0ff0,0x0000,0x0000,0x07f0,0x0000,
	0x007e,0x0000,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007e,0x0001,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0xffff,0x8000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x0fe0,0x0000,0x0000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x07f0,0x0000,0x4000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x07f0,0x001f,0xc000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x07f0,0x001f,0xc000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x03f8,0x001f,0xc000,0x07f0,0x0000,
	0x007f,0x0000,0x0000,0x03fc,0x003f,0xc000,0x07f0,0x0180,
	0x007f,0x0000,0x0006,0x03fc,0x003f,0xc002,0x07f0,0x0080,
	0x007c,0x0000,0x60fe,0x01ff,0x01ff,0x80fe,0x07f0,0x3f80,
	0x007f,0xffff,0xe0fe,0x00ff,0xffff,0x00fe,0x07f0,0x3f80,
	0x007f,0xffff,0xe0fe,0x007f,0xffff,0x00fe,0x07f0,0x3f80,
	0x007f,0xffff,0xe0fe,0x003f,0xfffe,0x00fe,0x07f0,0x3f80,
	0x007f,0xffff,0xe0fe,0x003f,0xfff8,0x00fe,0x07f0,0x3f80,
	0x017f,0xffff,0xe1fe,0x000f,0xfff0,0x01fe,0x17f0,0x7f80,
	0x01ff,0xffff,0xe3fe,0x0003,0xff80,0x03fe,0x0ff0,0xff80,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b5img[] = {
	0x07ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xfffe,
	0x05cf,0x3bde,0xf7bd,0xe739,0xde73,0xbdef,0x39de,0x739e,
	0x0730,0x6318,0xc631,0x9ce7,0x18ce,0x318c,0xe719,0xce72,
	0x0466,0xcc63,0x18c6,0x1084,0x6308,0xc630,0x8461,0x0846,
	0x05cc,0xcce7,0x39ce,0x77bc,0xe779,0xde77,0xbcef,0x7bce,
	0x0599,0x9b9c,0xe739,0xc633,0x8007,0x19c6,0x338c,0x633a,
	0x0498,0x0000,0x0221,0x18c6,0x0000,0x6118,0xc200,0x8c22,
	0x0490,0x0000,0x066f,0x79cc,0x0550,0x6f39,0xde01,0x9dee,
	0x06b1,0x5555,0x56ec,0xe738,0x2aaa,0x8ce7,0x1915,0xf18e,
	0x04c2,0xaaaa,0xaf91,0x0420,0x5555,0x1084,0x612b,0x8632,
	0x05d1,0x5555,0x5687,0x34e1,0x5555,0x53bd,0xef15,0xdef2,
	0x0731,0x4aaa,0xae74,0xa785,0x5fea,0xae31,0x9c2b,0xd8ce,
	0x0462,0xbfff,0xfe54,0xb602,0xbffa,0xaec6,0x1115,0x830a,
	0x04c1,0x5fff,0xfec7,0xb28a,0xfd3d,0x56ce,0x732b,0xcd3a,
	0x0712,0xbe8a,0xa136,0x8c85,0xf492,0xae59,0xce15,0xa8e2,
	0x0471,0x5880,0x2330,0x9c15,0xe0a4,0x56c2,0x492b,0x8f8e,
	0x05e2,0xbcad,0xaf26,0xe50b,0xe794,0xbfce,0x6915,0x993e,
	0x0511,0x5af9,0xecf4,0xcc15,0xc4be,0xff38,0xc72b,0xb932,
	0x0562,0xb849,0x0886,0xcc2b,0x9db0,0xf923,0x9c15,0xc562,
	0x0521,0x5bcf,0x3b9b,0x3217,0xccc6,0x526e,0x312b,0x90ee,
	0x0732,0xb000,0x0251,0x3257,0x045e,0xd26c,0xc715,0xdb8e,
	0x0671,0x5000,0x0e5d,0x262b,0xbd99,0x1ad1,0xde2b,0x8e4a,
	0x05c2,0xaaaa,0xad51,0xec57,0x61b0,0x6307,0x1915,0xb26e,
	0x0501,0x5555,0x5c73,0x8c2b,0x0e27,0xcf74,0x612b,0xf656,
	0x0732,0xaaaa,0xacce,0x3257,0x6cec,0x9c64,0xef15,0x8662,
	0x04f1,0x5555,0x5fc8,0x722b,0xc98d,0xb257,0x8c2b,0xccee,
	0x0482,0xbfff,0xfc2b,0xce57,0x4e31,0x9346,0x3315,0xa98a,
	0x0691,0x5fff,0xfec7,0x082b,0x38f6,0x4e78,0x732b,0x8c3a,
	0x04f2,0xbd2d,0x505c,0x7a57,0x26c6,0x30cb,0xcc15,0x9de6,
	0x05c1,0x5880,0x2464,0xe315,0xe698,0x47a7,0x242b,0xb326,
	0x0712,0xbc94,0x87e7,0x8c2b,0x9818,0x023c,0x3315,0xc32e,
	0x0431,0x5afd,0xfb24,0x1d15,0xcde0,0x57a1,0xcf2b,0x9cee,
	0x05e2,0xb843,0x4c26,0xf1aa,0xa128,0xaf33,0xc815,0xd886,
	0x0591,0x5bdb,0x05ec,0xc715,0x5f90,0x5626,0x4b2b,0x8792,
	0x0492,0xbb18,0xbd80,0x0c0a,0xa141,0x5ee0,0x0f15,0xb00e,
	0x04d1,0x5800,0x0020,0x39d5,0x4001,0x5f80,0x1c2b,0xb006,
	0x0692,0xa000,0x03e2,0xb92a,0xa805,0x5c25,0x7815,0xc15e,
	0x04d2,0xaaaa,0xab05,0x7335,0x5555,0x7a62,0xb32b,0xc8ae,
	0x05c1,0x5555,0x5762,0xb7aa,0xaaaa,0xf9c5,0x7315,0x995e,
	0x0732,0xaaaa,0xab65,0x7031,0xeaab,0xf922,0xbc2b,0xb8ae,
	0x0492,0xaaaa,0xab82,0xb677,0xf55f,0xc722,0xb52b,0x815e,
	0x05cb,0xffff,0xff2f,0xfed3,0x7fff,0xe4af,0xf1bf,0xb3fe,
	0x04bf,0xffff,0xff3f,0xf011,0x1ffd,0x14bf,0xf67f,0xe7fe,
	0x0441,0x5161,0x6125,0x86f7,0x2544,0x23a2,0x96e8,0x0d26,
	0x07d9,0x0606,0x0664,0x36c4,0xe40c,0xee4c,0x9181,0x9c86,
	0x070f,0x2ece,0xced4,0xe494,0x94b9,0x88cc,0xd233,0xf0be,
	0x07ff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xfffe,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

static int rs_b4img[] = {
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xcfff,0xffff,0xffdf,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0x7fff,0xffff,0xffbf,0xffff,
	0x0fff,0xffff,0xffff,0xfffe,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffdf,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffbf,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xff7f,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xfffc,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xfffd,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xfffd,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xfffb,0xffff,0xffff,0xffff,
	0x0fff,0xffbd,0xfff7,0xffff,0xffef,0xffff,0xffff,0xfbff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
	0x0fff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff
};

static int rs_b3img[] = {
	0x0fe0,0x7ffc,0x3ffc,0x1ff0,0x0fe0,0x0fe0,0x7ffc,0x3ffc,
	0x1ff0,0x0fe0,0x0fe0,0x7ffc,0x3ffc,0x1ff0,0x0fe0,0x0fe0
};

static int rs_b2img[] = {
	0x0fe0,0x7bfc,0x3e3c,0x1e30,0x0be0,0x0be0,0x7bfc,0x3e3c,
	0x1e30,0x0a60,0x0be0,0x7a7c,0x3c3c,0x1c30,0x0a60,0x0fe0,
	0x0fe0,0x7ffc,0x3e3c,0x1e30,0x0fe0,0x0fe0,0x7ffc,0x3e3c,
	0x1e30,0x0e60,0x0fe0,0x7ffc,0x3ffc,0x1ff0,0x0fe0,0x0fe0,
	0x0fe0,0x5ffc,0x3e3c,0x1e30,0x0fe0,0x0fe0,0x5ffc,0x3e3c,
	0x1e30,0x0e60,0x0fe0,0x5e7c,0x3c3c,0x1c30,0x0e60,0x0fe0,
	0x0fe0,0x7ffc,0x3dfc,0x1df0,0x0ee0,0x0fe0,0x7ffc,0x3dfc,
	0x1df0,0x0fe0,0x0fe0,0x7e7c,0x3e3c,0x1e30,0x0fe0,0x0fe0
};

static int rs_b1img[] = {
	0x3fe0,0x2050,0x2048,0x2044,0x207c,0x2004,0x2004,0x2004,
	0x2004,0x2004,0x2004,0x2004,0x2004,0x2004,0x2004,0x3ffc
};

static int rs_b0img[] = {
	0x3fe0,0x3ff0,0x3ff8,0x3ffc,0x3ffc,0x3ffc,0x3ffc,0x3ffc,
	0x3ffc,0x3ffc,0x3ffc,0x3ffc,0x3ffc,0x3ffc,0x3ffc,0x3ffc
};

static CICON rs_cicon[] = {
#define CI0 0
/* CICON 0 */
	4, rs_b2img, rs_b3img, 0L, 0L, 0L,

#define CI1 1
/* CICON 1 */
	4, rs_b6img, rs_b7img, 0L, 0L, 0L,

#define CI2 2
/* CICON 2 */
	4, rs_b10img, rs_b11img, 0L, 0L, &rs_cicon[3],
	8, rs_b12img, rs_b13img, rs_b14img, rs_b15img, 0L,

#define CI3 4
/* CICON 3 */
	4, rs_b18img, rs_b19img, 0L, 0L, 0L,

#define CI4 5
/* CICON 4 */
	4, rs_b22img, rs_b23img, 0L, 0L, 0L,

#define CI5 6
/* CICON 5 */
	8, rs_b26img, rs_b27img, 0L, 0L, 0L
};

#define RS_NCICNBLK 6

static CICONBLK rs_ciconblk[] = {
	rs_b0img, rs_b1img, rs_s3, 4096, 0, 0,
	0, 0, 16, 16, 5, 5, 6, 8,
	&rs_cicon[CI0],

	rs_b4img, rs_b5img, rs_s4, 4096, 0, 0,
	0, 0, 128, 48, 0, 0, 0, 8,
	&rs_cicon[CI1],

	rs_b8img, rs_b9img, rs_s5, 4096, 0, 0,
	0, 0, 32, 28, 13, 13, 6, 8,
	&rs_cicon[CI2],

	rs_b16img, rs_b17img, rs_s6, 4096, 0, 0,
	0, 0, 32, 24, 0, 0, 0, 8,
	&rs_cicon[CI3],

	rs_b20img, rs_b21img, "E.C.I.", 4096, 12, 20,
	2, 0, 32, 32, 0, 32, 36, 8,
	&rs_cicon[CI4],

	rs_b24img, rs_b25img, rs_s7, 4096, 20, 0,
	0, 0, 32, 32, 0, 24, 0, 0,
	&rs_cicon[CI5]
};

#define RS_NOBS 50

static OBJECT rs_obj[] = {
#define TR0 0
/* TREE 0 */
	-1, 1, 5, G_IBOX,			/*** 0 ***/
	NONE,
	NORMAL,
	(long) 0L,
	0, 0, 80, 25,

	5, 2, 2, G_BOX,			/*** 1 ***/
	NONE,
	NORMAL,
	(long) 4352L,
	0, 0, 80, 513,

	1, 3, 4, G_IBOX,			/*** 2 ***/
	NONE,
	NORMAL,
	(long) 0L,
	2, 0, 12, 769,

	4, -1, -1, G_TITLE,			/*** 3 ***/
	NONE,
	NORMAL,
	(long) " ECI",
	0, 0, 5, 769,

	2, -1, -1, G_TITLE,			/*** 4 ***/
	NONE,
	NORMAL,
	(long) " Datei",
	5, 0, 7, 769,

	0, 6, 15, G_IBOX,			/*** 5 ***/
	NONE,
	NORMAL,
	(long) 0L,
	0, 769, 24, 8,

	15, 7, 14, G_BOX,			/*** 6 ***/
	NONE,
	NORMAL,
	(long) 16716032L,
	2, 0, 19, 8,

	8, -1, -1, G_STRING,			/*** 7 ***/
	NONE,
	NORMAL,
	(long) "  \232ber ECI...  ",
	0, 0, 19, 1,

	9, -1, -1, G_STRING,			/*** 8 ***/
	NONE,
	DISABLED,
	(long) "-------------------",
	0, 1, 19, 1,

	10, -1, -1, G_STRING,			/*** 9 ***/
	NONE,
	NORMAL,
	(long) "  Desk Accessory 1 ",
	0, 2, 19, 1,

	11, -1, -1, G_STRING,			/*** 10 ***/
	NONE,
	NORMAL,
	(long) "  Desk Accessory 2 ",
	0, 3, 19, 1,

	12, -1, -1, G_STRING,			/*** 11 ***/
	NONE,
	NORMAL,
	(long) "  Desk Accessory 3 ",
	0, 4, 19, 1,

	13, -1, -1, G_STRING,			/*** 12 ***/
	NONE,
	NORMAL,
	(long) "  Desk Accessory 4 ",
	0, 5, 19, 1,

	14, -1, -1, G_STRING,			/*** 13 ***/
	NONE,
	NORMAL,
	(long) "  Desk Accessory 5 ",
	0, 6, 19, 1,

	6, -1, -1, G_STRING,			/*** 14 ***/
	NONE,
	NORMAL,
	(long) "  Desk Accessory 6 ",
	0, 7, 19, 1,

	5, 16, 18, G_BOX,			/*** 15 ***/
	NONE,
	NORMAL,
	(long) 16715776L,
	7, 0, 17, 3,

	17, -1, -1, G_STRING,			/*** 16 ***/
	NONE,
	NORMAL,
	(long) "  \231ffnen...   ^O ",
	0, 0, 17, 1,

	18, -1, -1, G_STRING,			/*** 17 ***/
	NONE,
	DISABLED,
	(long) "-----------------",
	0, 1, 17, 1,

	15, -1, -1, G_STRING,			/*** 18 ***/
	LASTOB,
	NORMAL,
	(long) "  Ende        ^Q ",
	0, 2, 17, 1,

#define TR1 19
/* TREE 1 */
	-1, 1, 14, G_BOX,			/*** 0 ***/
	FL3DBAK,
	OUTLINED,
	(long) 135424L,
	0, 0, 40, 2067,

	2, -1, -1, G_STRING,			/*** 1 ***/
	FL3DBAK,
	WHITEBAK|STATE8|STATE9|STATE10|STATE11|STATE12|STATE13|STATE14|STATE15,
	(long) " \232ber ECI ",
	1, 0, 10, 1,

	3, -1, -1, G_STRING,			/*** 2 ***/
	FL3DBAK,
	NORMAL,
	(long) "Version:",
	2, 5, 8, 1,

	4, -1, -1, G_TEXT,			/*** 3 ***/
	FL3DBAK,
	NORMAL,
	(long) &rs_tedinfo[0],
	11, 5, 14, 1,

	5, -1, -1, G_TEXT,			/*** 4 ***/
	FL3DBAK,
	NORMAL,
	(long) &rs_tedinfo[1],
	2, 6, 20, 1,

	6, -1, -1, G_TEXT,			/*** 5 ***/
	FL3DBAK,
	NORMAL,
	(long) &rs_tedinfo[2],
	2, 7, 37, 1,

	7, 15, 15, G_BUTTON,			/*** 6 ***/
	SELECTABLE|DEFAULT|EXIT|FL3DIND|FL3DBAK,
	WHITEBAK,
	(long) rs_s2,
	15, 17, 10, 513,

	8, -1, -1, G_CICON,			/*** 7 ***/
	NONE,
	NORMAL,
	(long) &rs_ciconblk[1],
	12, 2049, 16, 3,

	9, -1, -1, G_CICON,			/*** 8 ***/
	NONE,
	NORMAL,
	(long) &rs_ciconblk[2],
	2, 9, 4, -1022,

	10, -1, -1, G_TEXT,			/*** 9 ***/
	NONE,
	NORMAL,
	(long) &rs_tedinfo[3],
	1031, 9, 29, 1,

	11, -1, -1, G_TEXT,			/*** 10 ***/
	NONE,
	NORMAL,
	(long) &rs_tedinfo[4],
	1031, 2059, 26, 1,

	12, -1, -1, G_TEXT,			/*** 11 ***/
	NONE,
	NORMAL,
	(long) &rs_tedinfo[5],
	1031, 2060, 30, 1,

	13, -1, -1, G_CICON,			/*** 12 ***/
	NONE,
	NORMAL,
	(long) &rs_ciconblk[3],
	2, 14, 4, 2049,

	14, -1, -1, G_TEXT,			/*** 13 ***/
	NONE,
	NORMAL,
	(long) &rs_tedinfo[6],
	1031, 14, 27, 1,

	0, -1, -1, G_TEXT,			/*** 14 ***/
	NONE,
	NORMAL,
	(long) &rs_tedinfo[7],
	1035, 15, 12, 1,

	6, -1, -1, G_CICON,			/*** 15 ***/
	LASTOB,
	NORMAL,
	(long) &rs_ciconblk[0],
	0, 0, 2, 1,

#define TR2 35
/* TREE 2 */
	-1, 1, 1, G_BOX,			/*** 0 ***/
	NONE,
	NORMAL,
	(long) 496L,
	0, 0, 9, 2052,

	0, -1, -1, G_CICON,			/*** 1 ***/
	LASTOB,
	NORMAL,
	(long) &rs_ciconblk[4],
	2, 1, 1028, 2050,

#define TR3 37
/* TREE 3 */
	-1, 1, 12, G_BOX,			/*** 0 ***/
	FL3DBAK,
	OUTLINED,
	(long) 135424L,
	0, 0, 34, 2066,

	2, -1, -1, G_STRING|(19<<8),			/*** 1 ***/
	NONE,
	WHITEBAK|STATE8|STATE9|STATE10|STATE11|STATE12|STATE13|STATE14|STATE15,
	(long) " Enhanced Character Interpreter ",
	1, 0, 32, 1,

	4, 3, 3, G_BUTTON|(20<<8),			/*** 2 ***/
	FL3DIND|FL3DBAK,
	WHITEBAK|STATE9|STATE10|STATE11|STATE12|STATE13|STATE14|STATE15,
	(long) " Abk\201rzung ",
	1, 2049, 31, 2051,

	2, -1, -1, G_FTEXT,			/*** 3 ***/
	EDITABLE|FL3DBAK,
	NORMAL,
	(long) &rs_tedinfo[8],
	2, 2049, 5, 1,

	10, 5, 9, G_BUTTON|(20<<8),			/*** 4 ***/
	FL3DIND|FL3DBAK,
	WHITEBAK|STATE9|STATE10|STATE11|STATE12|STATE13|STATE14|STATE15,
	(long) " \232bersetzung ",
	1, 6, 31, 9,

	6, -1, -1, G_STRING,			/*** 5 ***/
	NONE,
	NORMAL,
	(long) rs_s1,
	1025, 2049, 14, 1,

	7, -1, -1, G_STRING,			/*** 6 ***/
	NONE,
	NORMAL,
	(long) rs_s1,
	1025, 3, 14, 1,

	8, -1, -1, G_STRING,			/*** 7 ***/
	NONE,
	NORMAL,
	(long) rs_s1,
	1025, 2052, 14, 1,

	9, -1, -1, G_STRING,			/*** 8 ***/
	NONE,
	NORMAL,
	(long) rs_s1,
	1025, 6, 14, 1,

	4, -1, -1, G_STRING,			/*** 9 ***/
	NONE,
	NORMAL,
	(long) rs_s1,
	1025, 2055, 14, 1,

	11, -1, -1, G_BUTTON,			/*** 10 ***/
	SELECTABLE|DEFAULT|EXIT|FL3DIND|FL3DBAK,
	WHITEBAK,
	(long) rs_s2,
	21, 2064, 11, 513,

	12, -1, -1, G_BUTTON,			/*** 11 ***/
	SELECTABLE|EXIT|FL3DIND|FL3DBAK,
	WHITEBAK,
	(long) "Abbruch",
	8, 2064, 11, 513,

	0, -1, -1, G_CICON,			/*** 12 ***/
	LASTOB,
	NORMAL,
	(long) &rs_ciconblk[5],
	26, 1, 4, 2
};

OBJECT *MENUTREE		= &rs_obj[TR0];
OBJECT *ABOUT		= &rs_obj[TR1];
OBJECT *WINICON		= &rs_obj[TR2];
OBJECT *ECIDIAL		= &rs_obj[TR3];


void rs_init(void);
void rs_exit(void);

LONG rs_ciconinit(CICONBLK *ciconblks, WORD ncib, OBJECT *objects, WORD nobj);
void rs_ciconexit(LONG deskript);

static LONG rs_cid;
void rs_init(void)
{
	register OBJECT	*obj=rs_obj;
	register WORD	i=0;

	do
	{
		rsrc_obfix(obj, i);
	} while (++i<RS_NOBS);
	rs_cid = rs_ciconinit(&rs_ciconblk[0], 6, &rs_obj[0], 50);
}
void rs_exit(void)
{
	rs_ciconexit(rs_cid);
}
